/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.BlockContainer;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityRecordPlayer;
import net.minecraft.src.World;

public class BlockJukeBox
extends BlockContainer {
    public BlockJukeBox(int i) {
        super(i, Material.wood);
    }

    @Override
    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        if (world.getBlockMetadata(i, j, k) == 0) {
            return false;
        }
        this.playRecord(world, i, j, k);
        return true;
    }

    public void ejectRecord(World world, int i, int j, int k, int l) {
        if (!world.isMultiplayerAndNotHost) {
            TileEntityRecordPlayer tileentityrecordplayer = (TileEntityRecordPlayer)world.getBlockTileEntity(i, j, k);
            tileentityrecordplayer.record = l;
            tileentityrecordplayer.onInventoryChanged();
            world.setBlockMetadataWithNotify(i, j, k, 1);
        }
    }

    public void playRecord(World world, int i, int j, int k) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        TileEntityRecordPlayer tileentityrecordplayer = (TileEntityRecordPlayer)world.getBlockTileEntity(i, j, k);
        int l = tileentityrecordplayer.record;
        if (l != 0) {
            world.playSoundEffect(1005, i, j, k, 0);
            world.playRecord(null, i, j, k);
            tileentityrecordplayer.record = 0;
            tileentityrecordplayer.onInventoryChanged();
            world.setBlockMetadataWithNotify(i, j, k, 0);
            int i1 = l;
            float f = 0.7f;
            double d = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.2 + 0.6;
            double d2 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)i + d, (double)j + d1, (double)k + d2, new ItemStack(i1, 1, 0));
            entityitem.delayBeforeCanPickup = 10;
            world.entityJoinedWorld(entityitem);
        }
    }

    @Override
    public void onBlockRemoval(World world, int i, int j, int k) {
        this.playRecord(world, i, j, k);
        super.onBlockRemoval(world, i, j, k);
    }

    @Override
    public void dropBlockAsItemWithChance(World world, int i, int j, int k, int l, float f) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        super.dropBlockAsItemWithChance(world, i, j, k, l, f);
    }

    @Override
    protected TileEntity getBlockEntity() {
        return new TileEntityRecordPlayer();
    }
}

