/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockLayerBase;
import net.minecraft.src.BlockLeavesBase;
import net.minecraft.src.ColorProperties;
import net.minecraft.src.ColorizerFoliage;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.Season;
import net.minecraft.src.StatList;
import net.minecraft.src.World;

public class BlockLayerLeaves
extends BlockLayerBase {
    public BlockLayerLeaves(int i, Material material) {
        super(i, material);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        this.setTickOnLoad(true);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return null;
    }

    @Override
    public int getRenderColor(int i) {
        return ColorProperties.fRGB2iRGB(ColorProperties.oak.inventoryR, ColorProperties.oak.inventoryG, ColorProperties.oak.inventoryB);
    }

    @Override
    public int colorMultiplier(World world, IBlockAccess iblockaccess, int i, int j, int k) {
        int baseFoliageColor = ColorProperties.fRGB2iRGB(ColorProperties.oak.inventoryR, ColorProperties.oak.inventoryG, ColorProperties.oak.inventoryB);
        if (world != null) {
            double localTemperature = iblockaccess.getWorldChunkManager().getTemperature(i, k);
            double localHumidity = iblockaccess.getWorldChunkManager().getHumidity(i, k);
            Season season = world.getCurrentSeason();
            if (season != null) {
                float progress = world.getSeasonProgress();
                baseFoliageColor = ColorizerFoliage.getSeasonalColor(season, progress, localTemperature, localHumidity, ColorProperties.oak, true);
            }
        }
        return baseFoliageColor;
    }

    public void accumulate(World world, int x, int y, int z) {
        boolean negZValid;
        boolean negXValid;
        boolean posZValid;
        boolean posXValid;
        int myMetadata = world.getBlockMetadata(x, y, z);
        if (myMetadata == 7) {
            return;
        }
        boolean bl = posXValid = world.isBlockOpaqueCube(x + 1, y, z) || world.getBlockId(x + 1, y, z) == this.blockID && world.getBlockMetadata(x + 1, y, z) >= myMetadata;
        if (!posXValid) {
            return;
        }
        boolean bl2 = posZValid = world.isBlockOpaqueCube(x, y, z + 1) || world.getBlockId(x, y, z + 1) == this.blockID && world.getBlockMetadata(x, y, z + 1) >= myMetadata;
        if (!posZValid) {
            return;
        }
        boolean bl3 = negXValid = world.isBlockOpaqueCube(x - 1, y, z) || world.getBlockId(x - 1, y, z) == this.blockID && world.getBlockMetadata(x - 1, y, z) >= myMetadata;
        if (!negXValid) {
            return;
        }
        boolean bl4 = negZValid = world.isBlockOpaqueCube(x, y, z - 1) || world.getBlockId(x, y, z - 1) == this.blockID && world.getBlockMetadata(x, y, z - 1) >= myMetadata;
        if (!negZValid) {
            return;
        }
        world.setBlockMetadata(x, y, z, myMetadata + 1);
        world.markBlockNeedsUpdate(x, y, z);
    }

    @Override
    public boolean canPlaceBlockAt(World world, int i, int j, int k) {
        int l = world.getBlockId(i, j - 1, k);
        if (l == 0 || !Block.blocksList[l].isOpaqueCube() && !(Block.blocksList[l] instanceof BlockLeavesBase)) {
            return false;
        }
        Material material = world.getBlockMaterial(i, j - 1, k);
        return material.getIsSolid();
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        this.func_314_h(world, i, j, k);
    }

    private boolean func_314_h(World world, int i, int j, int k) {
        if (!this.canPlaceBlockAt(world, i, j, k)) {
            this.dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
            world.setBlockWithNotify(i, j, k, 0);
            return false;
        }
        return true;
    }

    @Override
    public void harvestBlock(World world, EntityPlayer entityplayer, int i, int j, int k, int l) {
        if (!world.isMultiplayerAndNotHost && entityplayer.getCurrentEquippedItem() != null && entityplayer.getCurrentEquippedItem().itemID == Item.toolShears.itemID) {
            entityplayer.addStat(StatList.mineBlockStatArray[this.blockID], 1);
            world.dropItem(i, j, k, new ItemStack(this.blockID, l + 1, 0));
        } else {
            super.harvestBlock(world, entityplayer, i, j, k, l);
        }
    }

    @Override
    public int idDropped(int i, Random random) {
        return 0;
    }

    @Override
    public int quantityDropped(int metadata, Random random) {
        return 0;
    }

    @Override
    public void updateTick(World world, int i, int j, int k, Random random) {
        if (world.currentSeason != null && !world.currentSeason.hasFallingLeaves) {
            int metadata = world.getBlockMetadata(i, j, k);
            if (random.nextInt(2) == 0) {
                if (metadata > 0) {
                    world.setBlockMetadata(i, j, k, metadata - 1);
                } else {
                    world.setBlockWithNotify(i, j, k, 0);
                }
            }
        }
    }
}

