/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockLayerBase;
import net.minecraft.src.BlockLeavesBase;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EnumLightType;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.Season;
import net.minecraft.src.World;

public class BlockLayerSnow
extends BlockLayerBase {
    public BlockLayerSnow(int i, Material material) {
        super(i, material);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        this.setTickOnLoad(true);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        int l = world.getBlockMetadata(i, j, k) & 7;
        float f = (float)(2 * (1 + l)) / 16.0f;
        return AxisAlignedBB.getBoundingBoxFromPool((double)i + this.minX, (double)j + this.minY, (double)k + this.minZ, (double)i + this.maxX, (float)j + f - 0.125f, (double)k + this.maxZ);
    }

    public void accumulate(World world, int x, int y, int z) {
        boolean negZValid;
        boolean negXValid;
        boolean posZValid;
        boolean posXValid;
        int myMetadata = world.getBlockMetadata(x, y, z);
        if (myMetadata == 7) {
            return;
        }
        boolean bl = posXValid = world.isBlockOpaqueCube(x + 1, y, z) || world.getBlockId(x + 1, y, z) == this.blockID && world.getBlockMetadata(x + 1, y, z) >= myMetadata;
        if (!posXValid) {
            return;
        }
        boolean bl2 = posZValid = world.isBlockOpaqueCube(x, y, z + 1) || world.getBlockId(x, y, z + 1) == this.blockID && world.getBlockMetadata(x, y, z + 1) >= myMetadata;
        if (!posZValid) {
            return;
        }
        boolean bl3 = negXValid = world.isBlockOpaqueCube(x - 1, y, z) || world.getBlockId(x - 1, y, z) == this.blockID && world.getBlockMetadata(x - 1, y, z) >= myMetadata;
        if (!negXValid) {
            return;
        }
        boolean bl4 = negZValid = world.isBlockOpaqueCube(x, y, z - 1) || world.getBlockId(x, y, z - 1) == this.blockID && world.getBlockMetadata(x, y, z - 1) >= myMetadata;
        if (!negZValid) {
            return;
        }
        world.setBlockMetadata(x, y, z, myMetadata + 1);
        world.markBlockNeedsUpdate(x, y, z);
    }

    @Override
    public boolean canPlaceBlockAt(World world, int i, int j, int k) {
        int l = world.getBlockId(i, j - 1, k);
        if (l == 0 || !Block.blocksList[l].isOpaqueCube() && !(Block.blocksList[l] instanceof BlockLeavesBase)) {
            return false;
        }
        Material material = world.getBlockMaterial(i, j - 1, k);
        return material == Material.leaves || material.getIsSolid();
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        this.func_314_h(world, i, j, k);
    }

    private boolean func_314_h(World world, int i, int j, int k) {
        if (!this.canPlaceBlockAt(world, i, j, k)) {
            this.dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
            world.setBlockWithNotify(i, j, k, 0);
            return false;
        }
        return true;
    }

    @Override
    public void harvestBlock(World world, EntityPlayer entityplayer, int i, int j, int k, int l) {
        super.harvestBlock(world, entityplayer, i, j, k, l);
        int i1 = Item.ammoSnowball.itemID;
        float f = 0.7f;
        double d = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d1 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d2 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        EntityItem entityitem = new EntityItem(world, (double)i + d, (double)j + d1, (double)k + d2, new ItemStack(i1, 1, 0));
        entityitem.delayBeforeCanPickup = 10;
        world.entityJoinedWorld(entityitem);
    }

    @Override
    public int idDropped(int i, Random random) {
        return Item.ammoSnowball.itemID;
    }

    @Override
    public int quantityDropped(int metadata, Random random) {
        return 0;
    }

    @Override
    public void updateTick(World world, int i, int j, int k, Random random) {
        if (world.getSavedLightValue(EnumLightType.Block, i, j, k) > 11) {
            this.dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
            world.setBlockWithNotify(i, j, k, 0);
        }
        if (world.getBlockBiome(i, k) != null && !world.getBlockBiome(i, k).hasSurfaceSnow() && world.getCurrentSeason() != Season.surfaceWinter) {
            this.dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
            world.setBlockWithNotify(i, j, k, 0);
        }
    }
}

