/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.PistonModel;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityPiston;
import net.minecraft.src.World;

public class BlockPistonMoving
extends BlockContainer {
    public BlockPistonMoving(int i) {
        super(i, Material.piston);
        this.setHardness(-1.0f);
    }

    @Override
    protected TileEntity getBlockEntity() {
        return null;
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
    }

    @Override
    public void onBlockRemoval(World world, int i, int j, int k) {
        TileEntity tileentity = world.getBlockTileEntity(i, j, k);
        if (tileentity != null && tileentity instanceof TileEntityPiston) {
            ((TileEntityPiston)tileentity).clearPistonTileEntity();
        } else {
            super.onBlockRemoval(world, i, j, k);
        }
    }

    @Override
    public boolean canPlaceBlockAt(World world, int i, int j, int k) {
        return false;
    }

    @Override
    public boolean canPlaceBlockOnSide(World world, int i, int j, int k, int l) {
        return false;
    }

    @Override
    public int getRenderType() {
        return -1;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        if (!world.isMultiplayerAndNotHost && world.getBlockTileEntity(i, j, k) == null) {
            world.setBlockWithNotify(i, j, k, 0);
            return true;
        }
        return false;
    }

    @Override
    public int idDropped(int i, Random random) {
        return 0;
    }

    @Override
    public void dropBlockAsItemWithChance(World world, int i, int j, int k, int l, float f) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        TileEntityPiston tileentitypiston = this.func_31034_c(world, i, j, k);
        if (tileentitypiston == null) {
            return;
        }
        Block.blocksList[tileentitypiston.getStoredBlockID()].dropBlockAsItem(world, i, j, k, tileentitypiston.getBlockMetadata());
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (world.isMultiplayerAndNotHost || world.getBlockTileEntity(i, j, k) != null) {
            // empty if block
        }
    }

    public static TileEntity func_31036_a(int i, int j, int k, boolean flag, boolean flag1) {
        return new TileEntityPiston(i, j, k, flag, flag1);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        TileEntityPiston tileentitypiston = this.func_31034_c(world, i, j, k);
        if (tileentitypiston == null) {
            return null;
        }
        float f = tileentitypiston.func_31008_a(0.0f);
        if (tileentitypiston.func_31015_b()) {
            f = 1.0f - f;
        }
        return this.func_31035_a(world, i, j, k, tileentitypiston.getStoredBlockID(), f, tileentitypiston.func_31009_d());
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int i, int j, int k) {
        TileEntityPiston tileentitypiston = this.func_31034_c(world, i, j, k);
        if (tileentitypiston != null) {
            Block block = Block.blocksList[tileentitypiston.getStoredBlockID()];
            if (block == null || block == this) {
                return;
            }
            block.setBlockBoundsBasedOnState(world, i, j, k);
            float f = tileentitypiston.func_31008_a(0.0f);
            if (tileentitypiston.func_31015_b()) {
                f = 1.0f - f;
            }
            int l = tileentitypiston.func_31009_d();
            this.minX = block.minX - (double)((float)PistonModel.xOffset[l] * f);
            this.minY = block.minY - (double)((float)PistonModel.yOffset[l] * f);
            this.minZ = block.minZ - (double)((float)PistonModel.zOffset[l] * f);
            this.maxX = block.maxX - (double)((float)PistonModel.xOffset[l] * f);
            this.maxY = block.maxY - (double)((float)PistonModel.yOffset[l] * f);
            this.maxZ = block.maxZ - (double)((float)PistonModel.zOffset[l] * f);
        }
    }

    public AxisAlignedBB func_31035_a(World world, int i, int j, int k, int l, float f, int i1) {
        if (l == 0 || l == this.blockID) {
            return null;
        }
        AxisAlignedBB axisalignedbb = Block.blocksList[l].getCollisionBoundingBoxFromPool(world, i, j, k);
        if (axisalignedbb == null) {
            return null;
        }
        axisalignedbb.minX -= (double)((float)PistonModel.xOffset[i1] * f);
        axisalignedbb.maxX -= (double)((float)PistonModel.xOffset[i1] * f);
        axisalignedbb.minY -= (double)((float)PistonModel.yOffset[i1] * f);
        axisalignedbb.maxY -= (double)((float)PistonModel.yOffset[i1] * f);
        axisalignedbb.minZ -= (double)((float)PistonModel.zOffset[i1] * f);
        axisalignedbb.maxZ -= (double)((float)PistonModel.zOffset[i1] * f);
        return axisalignedbb;
    }

    private TileEntityPiston func_31034_c(IBlockAccess iblockaccess, int i, int j, int k) {
        TileEntity tileentity = iblockaccess.getBlockTileEntity(i, j, k);
        if (tileentity != null && tileentity instanceof TileEntityPiston) {
            return (TileEntityPiston)tileentity;
        }
        return null;
    }
}

