/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.ChunkPosition;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Item;
import net.minecraft.src.Material;
import net.minecraft.src.ModelBed;
import net.minecraft.src.World;

public class BlockRedstoneWire
extends Block {
    private boolean wiresProvidePower = true;
    private Set field_21031_b = new HashSet();

    public BlockRedstoneWire(int i) {
        super(i, Material.circuits);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return null;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 5;
    }

    @Override
    public int colorMultiplier(World world, IBlockAccess iblockaccess, int i, int j, int k) {
        return 0x800000;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int i, int j, int k) {
        return world.canPlaceOnSurfaceOfBlock(i, j - 1, k);
    }

    private void updateAndPropagateCurrentStrength(World world, int i, int j, int k) {
        this.func_21030_a(world, i, j, k, i, j, k);
        ArrayList arraylist = new ArrayList(this.field_21031_b);
        this.field_21031_b.clear();
        for (int l = 0; l < arraylist.size(); ++l) {
            ChunkPosition chunkposition = (ChunkPosition)arraylist.get(l);
            world.notifyBlocksOfNeighborChange(chunkposition.x, chunkposition.y, chunkposition.z, this.blockID);
        }
    }

    private void func_21030_a(World world, int i, int j, int k, int l, int i1, int j1) {
        int k1 = world.getBlockMetadata(i, j, k);
        int l1 = 0;
        this.wiresProvidePower = false;
        boolean flag = world.isBlockIndirectlyGettingPowered(i, j, k);
        this.wiresProvidePower = true;
        if (flag) {
            l1 = 15;
        } else {
            for (int i2 = 0; i2 < 4; ++i2) {
                int k2 = i;
                int i3 = k;
                if (i2 == 0) {
                    --k2;
                }
                if (i2 == 1) {
                    ++k2;
                }
                if (i2 == 2) {
                    --i3;
                }
                if (i2 == 3) {
                    ++i3;
                }
                if (k2 != l || j != i1 || i3 != j1) {
                    l1 = this.getMaxCurrentStrength(world, k2, j, i3, l1);
                }
                if (world.isBlockNormalCube(k2, j, i3) && !world.isBlockNormalCube(i, j + 1, k)) {
                    if (k2 == l && j + 1 == i1 && i3 == j1) continue;
                    l1 = this.getMaxCurrentStrength(world, k2, j + 1, i3, l1);
                    continue;
                }
                if (world.isBlockNormalCube(k2, j, i3) || k2 == l && j - 1 == i1 && i3 == j1) continue;
                l1 = this.getMaxCurrentStrength(world, k2, j - 1, i3, l1);
            }
            l1 = l1 > 0 ? --l1 : 0;
        }
        if (k1 != l1) {
            world.editingBlocks = true;
            world.setBlockMetadataWithNotify(i, j, k, l1);
            world.markBlocksDirty(i, j, k, i, j, k);
            world.editingBlocks = false;
            for (int j2 = 0; j2 < 4; ++j2) {
                int l2 = i;
                int j3 = k;
                int k3 = j - 1;
                if (j2 == 0) {
                    --l2;
                }
                if (j2 == 1) {
                    ++l2;
                }
                if (j2 == 2) {
                    --j3;
                }
                if (j2 == 3) {
                    ++j3;
                }
                if (world.isBlockNormalCube(l2, j, j3)) {
                    k3 += 2;
                }
                int l3 = 0;
                l3 = this.getMaxCurrentStrength(world, l2, j, j3, -1);
                l1 = world.getBlockMetadata(i, j, k);
                if (l1 > 0) {
                    --l1;
                }
                if (l3 >= 0 && l3 != l1) {
                    this.func_21030_a(world, l2, j, j3, i, j, k);
                }
                l3 = this.getMaxCurrentStrength(world, l2, k3, j3, -1);
                l1 = world.getBlockMetadata(i, j, k);
                if (l1 > 0) {
                    --l1;
                }
                if (l3 < 0 || l3 == l1) continue;
                this.func_21030_a(world, l2, k3, j3, i, j, k);
            }
            if (k1 == 0 || l1 == 0) {
                this.field_21031_b.add(new ChunkPosition(i, j, k));
                this.field_21031_b.add(new ChunkPosition(i - 1, j, k));
                this.field_21031_b.add(new ChunkPosition(i + 1, j, k));
                this.field_21031_b.add(new ChunkPosition(i, j - 1, k));
                this.field_21031_b.add(new ChunkPosition(i, j + 1, k));
                this.field_21031_b.add(new ChunkPosition(i, j, k - 1));
                this.field_21031_b.add(new ChunkPosition(i, j, k + 1));
            }
        }
    }

    private void notifyWireNeighborsOfNeighborChange(World world, int i, int j, int k) {
        if (world.getBlockId(i, j, k) != this.blockID) {
            return;
        }
        world.notifyBlocksOfNeighborChange(i, j, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i - 1, j, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i + 1, j, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j, k - 1, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j, k + 1, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j - 1, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j + 1, k, this.blockID);
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        super.onBlockAdded(world, i, j, k);
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        this.updateAndPropagateCurrentStrength(world, i, j, k);
        world.notifyBlocksOfNeighborChange(i, j + 1, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j - 1, k, this.blockID);
        this.notifyWireNeighborsOfNeighborChange(world, i - 1, j, k);
        this.notifyWireNeighborsOfNeighborChange(world, i + 1, j, k);
        this.notifyWireNeighborsOfNeighborChange(world, i, j, k - 1);
        this.notifyWireNeighborsOfNeighborChange(world, i, j, k + 1);
        if (world.isBlockNormalCube(i - 1, j, k)) {
            this.notifyWireNeighborsOfNeighborChange(world, i - 1, j + 1, k);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i - 1, j - 1, k);
        }
        if (world.isBlockNormalCube(i + 1, j, k)) {
            this.notifyWireNeighborsOfNeighborChange(world, i + 1, j + 1, k);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i + 1, j - 1, k);
        }
        if (world.isBlockNormalCube(i, j, k - 1)) {
            this.notifyWireNeighborsOfNeighborChange(world, i, j + 1, k - 1);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i, j - 1, k - 1);
        }
        if (world.isBlockNormalCube(i, j, k + 1)) {
            this.notifyWireNeighborsOfNeighborChange(world, i, j + 1, k + 1);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i, j - 1, k + 1);
        }
    }

    @Override
    public void onBlockRemoval(World world, int i, int j, int k) {
        super.onBlockRemoval(world, i, j, k);
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        world.notifyBlocksOfNeighborChange(i, j + 1, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j - 1, k, this.blockID);
        this.updateAndPropagateCurrentStrength(world, i, j, k);
        this.notifyWireNeighborsOfNeighborChange(world, i - 1, j, k);
        this.notifyWireNeighborsOfNeighborChange(world, i + 1, j, k);
        this.notifyWireNeighborsOfNeighborChange(world, i, j, k - 1);
        this.notifyWireNeighborsOfNeighborChange(world, i, j, k + 1);
        if (world.isBlockNormalCube(i - 1, j, k)) {
            this.notifyWireNeighborsOfNeighborChange(world, i - 1, j + 1, k);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i - 1, j - 1, k);
        }
        if (world.isBlockNormalCube(i + 1, j, k)) {
            this.notifyWireNeighborsOfNeighborChange(world, i + 1, j + 1, k);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i + 1, j - 1, k);
        }
        if (world.isBlockNormalCube(i, j, k - 1)) {
            this.notifyWireNeighborsOfNeighborChange(world, i, j + 1, k - 1);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i, j - 1, k - 1);
        }
        if (world.isBlockNormalCube(i, j, k + 1)) {
            this.notifyWireNeighborsOfNeighborChange(world, i, j + 1, k + 1);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i, j - 1, k + 1);
        }
    }

    private int getMaxCurrentStrength(World world, int i, int j, int k, int l) {
        if (world.getBlockId(i, j, k) != this.blockID) {
            return l;
        }
        int i1 = world.getBlockMetadata(i, j, k);
        if (i1 > l) {
            return i1;
        }
        return l;
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        int i1 = world.getBlockMetadata(i, j, k);
        boolean flag = this.canPlaceBlockAt(world, i, j, k);
        if (!flag) {
            this.dropBlockAsItem(world, i, j, k, i1);
            world.setBlockWithNotify(i, j, k, 0);
        } else {
            this.updateAndPropagateCurrentStrength(world, i, j, k);
        }
        super.onNeighborBlockChange(world, i, j, k, l);
    }

    @Override
    public int idDropped(int i, Random random) {
        return Item.dustRedstone.itemID;
    }

    @Override
    public boolean isIndirectlyPoweringTo(World world, int i, int j, int k, int l) {
        if (!this.wiresProvidePower) {
            return false;
        }
        return this.isPoweringTo(world, i, j, k, l);
    }

    @Override
    public boolean isPoweringTo(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        boolean flag3;
        if (!this.wiresProvidePower) {
            return false;
        }
        if (iblockaccess.getBlockMetadata(i, j, k) == 0) {
            return false;
        }
        if (l == 1) {
            return true;
        }
        boolean flag = BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i - 1, j, k, 1) || !iblockaccess.isBlockNormalCube(i - 1, j, k) && BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i - 1, j - 1, k, -1);
        boolean flag1 = BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i + 1, j, k, 3) || !iblockaccess.isBlockNormalCube(i + 1, j, k) && BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i + 1, j - 1, k, -1);
        boolean flag2 = BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i, j, k - 1, 2) || !iblockaccess.isBlockNormalCube(i, j, k - 1) && BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i, j - 1, k - 1, -1);
        boolean bl = flag3 = BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i, j, k + 1, 0) || !iblockaccess.isBlockNormalCube(i, j, k + 1) && BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i, j - 1, k + 1, -1);
        if (!iblockaccess.isBlockNormalCube(i, j + 1, k)) {
            if (iblockaccess.isBlockNormalCube(i - 1, j, k) && BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i - 1, j + 1, k, -1)) {
                flag = true;
            }
            if (iblockaccess.isBlockNormalCube(i + 1, j, k) && BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i + 1, j + 1, k, -1)) {
                flag1 = true;
            }
            if (iblockaccess.isBlockNormalCube(i, j, k - 1) && BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i, j + 1, k - 1, -1)) {
                flag2 = true;
            }
            if (iblockaccess.isBlockNormalCube(i, j, k + 1) && BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i, j + 1, k + 1, -1)) {
                flag3 = true;
            }
        }
        if (!(flag2 || flag1 || flag || flag3 || l < 2 || l > 5)) {
            return true;
        }
        if (l == 2 && flag2 && !flag && !flag1) {
            return true;
        }
        if (l == 3 && flag3 && !flag && !flag1) {
            return true;
        }
        if (l == 4 && flag && !flag2 && !flag3) {
            return true;
        }
        return l == 5 && flag1 && !flag2 && !flag3;
    }

    @Override
    public boolean canProvidePower() {
        return this.wiresProvidePower;
    }

    @Override
    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        int l = world.getBlockMetadata(i, j, k);
        if (l > 0) {
            double d = (double)i + 0.5 + ((double)random.nextFloat() - 0.5) * 0.2;
            double d1 = (float)j + 0.0625f;
            double d2 = (double)k + 0.5 + ((double)random.nextFloat() - 0.5) * 0.2;
            float f = (float)l / 15.0f;
            float f1 = f * 0.6f + 0.4f;
            if (l == 0) {
                f1 = 0.0f;
            }
            float f2 = f * f * 0.7f - 0.5f;
            float f3 = f * f * 0.6f - 0.7f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f3 < 0.0f) {
                f3 = 0.0f;
            }
            world.spawnParticle("reddust", d, d1, d2, f1, f2, f3);
        }
    }

    public static boolean isPowerProviderOrWire(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        int i1 = iblockaccess.getBlockId(i, j, k);
        if (i1 == Block.wireRedstone.blockID) {
            return true;
        }
        if (i1 == 0) {
            return false;
        }
        if (Block.blocksList[i1].canProvidePower()) {
            return true;
        }
        if (i1 == Block.repeaterIdle.blockID || i1 == Block.repeaterActive.blockID) {
            int j1 = iblockaccess.getBlockMetadata(i, j, k);
            return l == ModelBed.field_22279_b[j1 & 3];
        }
        return false;
    }
}

