/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.BlockSlab;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.World;
import net.minecraft.src.helper.Direction;

public class BlockSlabPainted
extends BlockSlab {
    public BlockSlabPainted(int id, Block modelBlock) {
        super(id, modelBlock);
    }

    @Override
    public int getRenderColor(int i) {
        return Block.planksOakPainted.getRenderColor((i & 0xF0) >> 4);
    }

    @Override
    public int colorMultiplier(World world, IBlockAccess iblockaccess, int i, int j, int k) {
        int meta = world.getBlockMetadata(i, j, k);
        return this.getRenderColor(meta);
    }

    @Override
    protected int damageDropped(int i) {
        return i & 0xF0;
    }

    public static int getMetadataForColour(int i) {
        return ~i << 4 & 0xF0;
    }

    @Override
    public void onBlockPlaced(World world, int x, int y, int z, Direction side, EntityLiving player, double sideHeight) {
        int meta = player.getVerticalPlacementDirection(side, sideHeight) == Direction.UP ? 2 : 0;
        world.setBlockMetadataWithNotify(x, y, z, meta | world.getBlockMetadata(x, y, z) & 0xF0);
    }
}

