/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Material;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;
import net.minecraft.src.helper.Direction;
import net.minecraft.src.helper.PlacementMode;

public class BlockTrapDoor
extends Block {
    public BlockTrapDoor(int i, Material material) {
        super(i, material);
        float f = 0.5f;
        float f1 = 1.0f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f1, 0.5f + f);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 0;
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int i, int j, int k) {
        this.setBlockBoundsBasedOnState(world, i, j, k);
        return super.getSelectedBoundingBoxFromPool(world, i, j, k);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        this.setBlockBoundsBasedOnState(world, i, j, k);
        return super.getCollisionBoundingBoxFromPool(world, i, j, k);
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int i, int j, int k) {
        this.setBlockBoundsForBlockRender(world.getBlockMetadata(i, j, k));
    }

    @Override
    public void setBlockBoundsForItemRender() {
        float f = 0.1875f;
        this.setBlockBounds(0.0f, 0.5f - f / 2.0f, 0.0f, 1.0f, 0.5f + f / 2.0f, 1.0f);
    }

    public void setBlockBoundsForBlockRender(int i) {
        float f = 0.1875f;
        if (BlockTrapDoor.isTrapdoorOpen(i)) {
            if ((i & 3) == 0) {
                this.setBlockBounds(0.0f, 0.0f, 1.0f - f, 1.0f, 1.0f, 1.0f);
            }
            if ((i & 3) == 1) {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f);
            }
            if ((i & 3) == 2) {
                this.setBlockBounds(1.0f - f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
            if ((i & 3) == 3) {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, f, 1.0f, 1.0f);
            }
        } else if (BlockTrapDoor.isUpperHalf(i)) {
            this.setBlockBounds(0.0f, 1.0f - f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, f, 1.0f);
        }
    }

    @Override
    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        if (this.blockMaterial != Material.iron) {
            int l = world.getBlockMetadata(i, j, k);
            world.setBlockMetadataWithNotify(i, j, k, l ^ 4);
            world.playSoundEffectForPlayer(entityplayer, 1003, i, j, k, 0);
            return true;
        }
        return false;
    }

    public void onPoweredBlockChange(World world, int i, int j, int k, boolean flag) {
        boolean flag1;
        int l = world.getBlockMetadata(i, j, k);
        boolean bl = flag1 = (l & 4) > 0;
        if (flag1 != flag) {
            world.setBlockMetadataWithNotify(i, j, k, l ^ 4);
            world.playSoundEffectForPlayer(null, 1003, i, j, k, 0);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        if (l > 0 && Block.blocksList[l].canProvidePower()) {
            boolean flag = world.isBlockIndirectlyGettingPowered(i, j, k);
            this.onPoweredBlockChange(world, i, j, k, flag);
        }
    }

    @Override
    public MovingObjectPosition collisionRayTrace(World world, int i, int j, int k, Vec3D vec3d, Vec3D vec3d1) {
        this.setBlockBoundsBasedOnState(world, i, j, k);
        return super.collisionRayTrace(world, i, j, k, vec3d, vec3d1);
    }

    @Override
    public void onBlockPlaced(World world, int x, int y, int z, Direction side, EntityLiving player, double sideHeight) {
        int meta = Direction.getLegacySide2(player.getHorizontalPlacementDirection(side, PlacementMode.SIDE).getOpposite());
        if (player.getVerticalPlacementDirection(side, sideHeight) == Direction.UP) {
            meta |= 8;
        }
        world.setBlockMetadata(x, y, z, meta);
    }

    public static boolean isTrapdoorOpen(int i) {
        return (i & 4) != 0;
    }

    public static boolean isUpperHalf(int meta) {
        return (meta & 8) != 0;
    }
}

