/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.ChunkBlockMap;
import net.minecraft.src.ChunkPosition;
import net.minecraft.src.Entity;
import net.minecraft.src.EnumLightType;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NibbleArray;
import net.minecraft.src.NibbleArrayExtended;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;

public class Chunk {
    public static boolean isLit;
    public short[] blocks;
    public boolean isChunkLoaded;
    public World worldObj;
    public NibbleArrayExtended data;
    public NibbleArray skylightMap;
    public NibbleArray blocklightMap;
    public byte[] heightMap;
    public int lowestBlockHeight;
    public final int xPosition;
    public final int zPosition;
    public Map chunkTileEntityMap = new HashMap();
    public List[] entities = new List[Minecraft.WORLD_HEIGHT_BLOCKS / 16];
    public double[] temperature;
    public double[] humidity;
    public byte[] biome;
    public boolean isTerrainPopulated = false;
    public boolean isModified = false;
    public boolean neverSave;
    public boolean hasEntities = false;
    public long lastSaveTime = 0L;
    public boolean receivedFromServer = false;
    public long ticksUnreceived = 0L;

    public Chunk(World world, int i, int j) {
        this.worldObj = world;
        this.xPosition = i;
        this.zPosition = j;
        this.heightMap = new byte[256];
        this.biome = new byte[256];
        this.temperature = new double[256];
        this.humidity = new double[256];
        for (int k = 0; k < this.entities.length; ++k) {
            this.entities[k] = new ArrayList();
        }
    }

    public Chunk(World world, short[] ashort0, int i, int j) {
        this(world, i, j);
        if (ashort0.length < 256 * Minecraft.WORLD_HEIGHT_BLOCKS) {
            this.blocks = new short[256 * Minecraft.WORLD_HEIGHT_BLOCKS];
            System.arraycopy(ashort0, 0, this.blocks, 0, ashort0.length);
        } else {
            this.blocks = ashort0;
        }
        this.data = new NibbleArrayExtended(ashort0.length);
        this.skylightMap = new NibbleArray(ashort0.length);
        this.blocklightMap = new NibbleArray(ashort0.length);
        Arrays.fill(this.temperature, Double.NEGATIVE_INFINITY);
        Arrays.fill(this.humidity, Double.NEGATIVE_INFINITY);
        Arrays.fill(this.biome, (byte)-1);
    }

    public boolean isAtLocation(int i, int j) {
        return i == this.xPosition && j == this.zPosition;
    }

    public int getHeightValue(int i, int j) {
        return Byte.toUnsignedInt(this.heightMap[j << 4 | i]);
    }

    public void func_1014_a() {
    }

    public void generateHeightMap() {
        int i = Minecraft.WORLD_HEIGHT_BLOCKS - 1;
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                int l;
                int i1 = j << Minecraft.WORLD_HEIGHT_BITS + 4 | k << Minecraft.WORLD_HEIGHT_BITS;
                for (l = Minecraft.WORLD_HEIGHT_BLOCKS - 1; l > 0 && Block.lightOpacity[this.blocks[i1 + l - 1] & 0x3FFF] == 0; --l) {
                }
                this.heightMap[k << 4 | j] = (byte)l;
                if (l >= i) continue;
                i = l;
            }
        }
        this.lowestBlockHeight = i;
        this.isModified = true;
    }

    public void func_1024_c() {
        int i = Minecraft.WORLD_HEIGHT_BLOCKS - 1;
        for (int j = 0; j < 16; ++j) {
            for (int l = 0; l < 16; ++l) {
                int j1;
                int k1 = j << Minecraft.WORLD_HEIGHT_BITS + 4 | l << Minecraft.WORLD_HEIGHT_BITS;
                for (j1 = Minecraft.WORLD_HEIGHT_BLOCKS - 1; j1 > 0 && Block.lightOpacity[this.blocks[k1 + j1 - 1] & 0x3FFF] == 0; --j1) {
                }
                this.heightMap[l << 4 | j] = (byte)j1;
                if (j1 < i) {
                    i = j1;
                }
                if (this.worldObj.dimension.worldType.worldProvider.hasNoSky) continue;
                int l1 = 15;
                int i2 = Minecraft.WORLD_HEIGHT_BLOCKS - 1;
                do {
                    if ((l1 -= Block.lightOpacity[this.blocks[k1 + i2] & 0x3FFF]) <= 0) continue;
                    this.skylightMap.setNibble(j, i2, l, l1);
                } while (--i2 > 0 && l1 > 0);
            }
        }
        this.lowestBlockHeight = i;
        for (int k = 0; k < 16; ++k) {
            for (int i1 = 0; i1 < 16; ++i1) {
                this.func_996_c(k, i1);
            }
        }
        this.isModified = true;
    }

    public void func_4143_d() {
    }

    private void func_996_c(int i, int j) {
        int k = this.getHeightValue(i, j);
        int l = this.xPosition * 16 + i;
        int i1 = this.zPosition * 16 + j;
        this.func_1020_f(l - 1, i1, k);
        this.func_1020_f(l + 1, i1, k);
        this.func_1020_f(l, i1 - 1, k);
        this.func_1020_f(l, i1 + 1, k);
    }

    private void func_1020_f(int i, int j, int k) {
        int l = this.worldObj.getHeightValue(i, j);
        if (l > k) {
            this.worldObj.scheduleLightingUpdate(EnumLightType.Sky, i, k, j, i, l, j);
            this.isModified = true;
        } else if (l < k) {
            this.worldObj.scheduleLightingUpdate(EnumLightType.Sky, i, l, j, i, k, j);
            this.isModified = true;
        }
    }

    private void func_1003_g(int i, int j, int k) {
        int l;
        int i1 = l = this.heightMap[k << 4 | i] & 0xFF;
        if (j > l) {
            i1 = j;
        }
        int j1 = i << Minecraft.WORLD_HEIGHT_BITS + 4 | k << Minecraft.WORLD_HEIGHT_BITS;
        while (i1 > 0 && Block.lightOpacity[this.blocks[j1 + i1 - 1] & 0x3FFF] == 0) {
            --i1;
        }
        if (i1 == l) {
            return;
        }
        this.worldObj.markBlocksDirtyVertical(i, k, i1, l);
        this.heightMap[k << 4 | i] = (byte)i1;
        if (i1 < this.lowestBlockHeight) {
            this.lowestBlockHeight = i1;
        } else {
            int k1 = Minecraft.WORLD_HEIGHT_BLOCKS - 1;
            for (int i2 = 0; i2 < 16; ++i2) {
                for (int k2 = 0; k2 < 16; ++k2) {
                    if ((this.heightMap[k2 << 4 | i2] & 0xFF) >= k1) continue;
                    k1 = this.heightMap[k2 << 4 | i2] & 0xFF;
                }
            }
            this.lowestBlockHeight = k1;
        }
        int l1 = this.xPosition * 16 + i;
        int j2 = this.zPosition * 16 + k;
        if (i1 < l) {
            for (int l2 = i1; l2 < l; ++l2) {
                this.skylightMap.setNibble(i, l2, k, 15);
            }
        } else {
            this.worldObj.scheduleLightingUpdate(EnumLightType.Sky, l1, l, j2, l1, i1, j2);
            for (int i3 = l; i3 < i1; ++i3) {
                this.skylightMap.setNibble(i, i3, k, 0);
            }
        }
        int j3 = 15;
        int k3 = i1;
        while (i1 > 0 && j3 > 0) {
            int l3;
            if ((l3 = Block.lightOpacity[this.getBlockID(i, --i1, k)]) == 0) {
                l3 = 1;
            }
            if ((j3 -= l3) < 0) {
                j3 = 0;
            }
            this.skylightMap.setNibble(i, i1, k, j3);
        }
        while (i1 > 0 && Block.lightOpacity[this.getBlockID(i, i1 - 1, k)] == 0) {
            --i1;
        }
        if (i1 != k3) {
            this.worldObj.scheduleLightingUpdate(EnumLightType.Sky, l1 - 1, i1, j2 - 1, l1 + 1, k3, j2 + 1);
        }
        this.isModified = true;
    }

    public int getBlockID(int i, int j, int k) {
        return this.blocks[i << Minecraft.WORLD_HEIGHT_BITS + 4 | k << Minecraft.WORLD_HEIGHT_BITS | j] & 0x3FFF;
    }

    public boolean setBlockIDWithMetadata(int i, int j, int k, int l, int i1) {
        short short0 = (short)l;
        int j1 = this.heightMap[k << 4 | i] & 0xFF;
        int k1 = this.blocks[i << Minecraft.WORLD_HEIGHT_BITS + 4 | k << Minecraft.WORLD_HEIGHT_BITS | j] & 0x3FFF;
        if (k1 == l && this.data.getNibble(i, j, k) == i1) {
            return false;
        }
        int l1 = this.xPosition * 16 + i;
        int i2 = this.zPosition * 16 + k;
        this.blocks[i << Minecraft.WORLD_HEIGHT_BITS + 4 | k << Minecraft.WORLD_HEIGHT_BITS | j] = (short)(short0 & 0x3FFF);
        if (k1 != 0 && !this.worldObj.isMultiplayerAndNotHost) {
            Block.blocksList[k1].onBlockRemoval(this.worldObj, l1, j, i2);
        }
        this.data.setNibble(i, j, k, i1);
        if (!this.worldObj.dimension.worldType.worldProvider.hasNoSky) {
            if (Block.lightOpacity[short0 & 0x3FFF] != 0) {
                if (j >= j1) {
                    this.func_1003_g(i, j + 1, k);
                }
            } else if (j == j1 - 1) {
                this.func_1003_g(i, j, k);
            }
            this.worldObj.scheduleLightingUpdate(EnumLightType.Sky, l1, j, i2, l1, j, i2);
        }
        this.worldObj.scheduleLightingUpdate(EnumLightType.Block, l1, j, i2, l1, j, i2);
        this.func_996_c(i, k);
        this.data.setNibble(i, j, k, i1);
        if (l != 0) {
            Block.blocksList[l].onBlockAdded(this.worldObj, l1, j, i2);
        }
        this.isModified = true;
        return true;
    }

    public boolean setBlockID(int i, int j, int k, int l) {
        short short0 = (short)l;
        int i1 = this.heightMap[k << 4 | i] & 0xFF;
        int j1 = this.blocks[i << Minecraft.WORLD_HEIGHT_BITS + 4 | k << Minecraft.WORLD_HEIGHT_BITS | j] & 0x3FFF;
        if (j1 == l) {
            return false;
        }
        int k1 = this.xPosition * 16 + i;
        int l1 = this.zPosition * 16 + k;
        this.blocks[i << Minecraft.WORLD_HEIGHT_BITS + 4 | k << Minecraft.WORLD_HEIGHT_BITS | j] = (short)(short0 & 0x3FFF);
        if (j1 != 0) {
            Block.blocksList[j1].onBlockRemoval(this.worldObj, k1, j, l1);
        }
        this.data.setNibble(i, j, k, 0);
        if (Block.lightOpacity[short0 & 0x3FFF] != 0) {
            if (j >= i1) {
                this.func_1003_g(i, j + 1, k);
            }
        } else if (j == i1 - 1) {
            this.func_1003_g(i, j, k);
        }
        this.worldObj.scheduleLightingUpdate(EnumLightType.Sky, k1, j, l1, k1, j, l1);
        this.worldObj.scheduleLightingUpdate(EnumLightType.Block, k1, j, l1, k1, j, l1);
        this.func_996_c(i, k);
        if (l != 0 && !this.worldObj.isMultiplayerAndNotHost) {
            Block.blocksList[l].onBlockAdded(this.worldObj, k1, j, l1);
        }
        this.isModified = true;
        return true;
    }

    public boolean setBlockIDRaw(int i, int j, int k, int l) {
        short short0 = (short)l;
        int j1 = this.blocks[i << Minecraft.WORLD_HEIGHT_BITS + 4 | k << Minecraft.WORLD_HEIGHT_BITS | j] & 0x3FFF;
        if (j1 == l) {
            return false;
        }
        int k1 = this.xPosition * 16 + i;
        int l1 = this.zPosition * 16 + k;
        this.blocks[i << Minecraft.WORLD_HEIGHT_BITS + 4 | k << Minecraft.WORLD_HEIGHT_BITS | j] = (short)(short0 & 0x3FFF);
        this.data.setNibble(i, j, k, 0);
        this.worldObj.scheduleLightingUpdate(EnumLightType.Block, k1, j, l1, k1, j, l1);
        this.func_996_c(i, k);
        this.isModified = true;
        return true;
    }

    public int getBlockMetadata(int i, int j, int k) {
        return this.data.getNibble(i, j, k);
    }

    public void setBlockMetadata(int i, int j, int k, int l) {
        this.isModified = true;
        this.data.setNibble(i, j, k, l);
    }

    public BiomeGenBase getBlockBiome(int x, int z) {
        byte b = this.biome[x * 16 + z];
        if (b == -1) {
            return null;
        }
        return BiomeGenBase.biomeList[b];
    }

    public boolean setBlockBiome(int x, int z, BiomeGenBase biome) {
        byte presentBiome = this.biome[x * 16 + z];
        if (presentBiome == biome.id) {
            return false;
        }
        this.biome[x * 16 + z] = (byte)biome.id;
        return true;
    }

    public double getBlockTemperature(int x, int z) {
        return this.temperature[x * 16 + z];
    }

    public boolean setBlockTemperature(int x, int z, double temperature) {
        double presentTemperature = this.temperature[x * 16 + z];
        if (presentTemperature == temperature) {
            return false;
        }
        this.temperature[x * 16 + z] = temperature;
        return true;
    }

    public double getBlockHumidity(int x, int z) {
        return this.humidity[x * 16 + z];
    }

    public boolean setBlockHumidity(int x, int z, double humidity) {
        double presentHumidity = this.humidity[x * 16 + z];
        if (presentHumidity == humidity) {
            return false;
        }
        this.humidity[x * 16 + z] = humidity;
        return true;
    }

    public int getSavedLightValue(EnumLightType enumskyblock, int i, int j, int k) {
        if (enumskyblock == EnumLightType.Sky) {
            return this.skylightMap.getNibble(i, j, k);
        }
        if (enumskyblock == EnumLightType.Block) {
            return this.blocklightMap.getNibble(i, j, k);
        }
        return 0;
    }

    public void setLightValue(EnumLightType enumskyblock, int i, int j, int k, int l) {
        this.isModified = true;
        if (enumskyblock == EnumLightType.Sky) {
            this.skylightMap.setNibble(i, j, k, l);
        } else if (enumskyblock == EnumLightType.Block) {
            this.blocklightMap.setNibble(i, j, k, l);
        } else {
            return;
        }
    }

    public int getBlockLightValue(int i, int j, int k, int l) {
        int j1;
        int i1 = this.skylightMap.getNibble(i, j, k);
        if (i1 > 0) {
            isLit = true;
        }
        if ((j1 = this.blocklightMap.getNibble(i, j, k)) > (i1 -= l)) {
            i1 = j1;
        }
        return i1;
    }

    public void addEntity(Entity entity) {
        int k;
        this.hasEntities = true;
        int i = MathHelper.floor_double(entity.posX / 16.0);
        int j = MathHelper.floor_double(entity.posZ / 16.0);
        if (i != this.xPosition || j != this.zPosition) {
            System.out.println("Wrong location! " + entity);
            Thread.dumpStack();
        }
        if ((k = MathHelper.floor_double(entity.posY / 16.0)) < 0) {
            k = 0;
        }
        if (k >= this.entities.length) {
            k = this.entities.length - 1;
        }
        entity.addedToChunk = true;
        entity.chunkCoordX = this.xPosition;
        entity.chunkCoordY = k;
        entity.chunkCoordZ = this.zPosition;
        this.entities[k].add(entity);
    }

    public void removeEntity(Entity entity) {
        this.removeEntityAtIndex(entity, entity.chunkCoordY);
    }

    public void removeEntityAtIndex(Entity entity, int i) {
        if (i < 0) {
            i = 0;
        }
        if (i >= this.entities.length) {
            i = this.entities.length - 1;
        }
        this.entities[i].remove(entity);
    }

    public boolean canBlockSeeTheSky(int i, int j, int k) {
        return j >= (this.heightMap[k << 4 | i] & 0xFF);
    }

    public TileEntity getChunkBlockTileEntity(int i, int j, int k) {
        ChunkPosition chunkposition = new ChunkPosition(i, j, k);
        TileEntity tileentity = (TileEntity)this.chunkTileEntityMap.get(chunkposition);
        if (tileentity == null) {
            int l = this.getBlockID(i, j, k);
            if (!Block.isBlockContainer[l]) {
                return null;
            }
            BlockContainer blockcontainer = (BlockContainer)Block.blocksList[l];
            blockcontainer.onBlockAdded(this.worldObj, this.xPosition * 16 + i, j, this.zPosition * 16 + k);
            tileentity = (TileEntity)this.chunkTileEntityMap.get(chunkposition);
        }
        if (tileentity != null && tileentity.isInvalid()) {
            this.chunkTileEntityMap.remove(chunkposition);
            return null;
        }
        return tileentity;
    }

    public void addTileEntity(TileEntity tileentity) {
        int i = tileentity.xCoord - this.xPosition * 16;
        int j = tileentity.yCoord;
        int k = tileentity.zCoord - this.zPosition * 16;
        this.setChunkBlockTileEntity(i, j, k, tileentity);
        if (this.isChunkLoaded) {
            this.worldObj.loadedTileEntityList.add(tileentity);
        }
    }

    public void setChunkBlockTileEntity(int i, int j, int k, TileEntity tileentity) {
        ChunkPosition chunkposition = new ChunkPosition(i, j, k);
        tileentity.worldObj = this.worldObj;
        tileentity.xCoord = this.xPosition * 16 + i;
        tileentity.yCoord = j;
        tileentity.zCoord = this.zPosition * 16 + k;
        if (this.getBlockID(i, j, k) == 0 || !(Block.blocksList[this.getBlockID(i, j, k)] instanceof BlockContainer)) {
            System.out.println("Attempted to place a tile entity where there was no entity tile!");
            return;
        }
        tileentity.validate();
        this.chunkTileEntityMap.put(chunkposition, tileentity);
    }

    public void removeChunkBlockTileEntity(int i, int j, int k) {
        TileEntity tileentity;
        ChunkPosition chunkposition = new ChunkPosition(i, j, k);
        if (this.isChunkLoaded && (tileentity = (TileEntity)this.chunkTileEntityMap.remove(chunkposition)) != null) {
            tileentity.invalidate();
        }
    }

    public void onChunkLoad() {
        this.isChunkLoaded = true;
        this.worldObj.func_31054_a(this.chunkTileEntityMap.values());
        for (int i = 0; i < this.entities.length; ++i) {
            this.worldObj.addLoadedEntities(this.entities[i]);
        }
    }

    public void onChunkUnload() {
        this.isChunkLoaded = false;
        for (TileEntity tileentity : this.chunkTileEntityMap.values()) {
            tileentity.invalidate();
        }
        for (int i = 0; i < this.entities.length; ++i) {
            this.worldObj.unloadEntities(this.entities[i]);
        }
    }

    public void setChunkModified() {
        this.isModified = true;
    }

    public void getEntitiesWithinAABBForEntity(Entity entity, AxisAlignedBB axisalignedbb, List list) {
        int i = MathHelper.floor_double((axisalignedbb.minY - 2.0) / 16.0);
        int j = MathHelper.floor_double((axisalignedbb.maxY + 2.0) / 16.0);
        if (i < 0) {
            i = 0;
        }
        if (j >= this.entities.length) {
            j = this.entities.length - 1;
        }
        for (int k = i; k <= j; ++k) {
            List list1 = this.entities[k];
            for (int l = 0; l < list1.size(); ++l) {
                Entity entity1 = (Entity)list1.get(l);
                if (entity1 == entity || !entity1.boundingBox.intersectsWith(axisalignedbb)) continue;
                list.add(entity1);
            }
        }
    }

    public void getEntitiesOfTypeWithinAAAB(Class class1, AxisAlignedBB axisalignedbb, List list) {
        int i = MathHelper.floor_double((axisalignedbb.minY - 2.0) / 16.0);
        int j = MathHelper.floor_double((axisalignedbb.maxY + 2.0) / 16.0);
        if (i < 0) {
            i = 0;
        }
        if (j >= this.entities.length) {
            j = this.entities.length - 1;
        }
        for (int k = i; k <= j; ++k) {
            List list1 = this.entities[k];
            for (int l = 0; l < list1.size(); ++l) {
                Entity entity = (Entity)list1.get(l);
                if (!class1.isAssignableFrom(entity.getClass()) || !entity.boundingBox.intersectsWith(axisalignedbb)) continue;
                list.add(entity);
            }
        }
    }

    public boolean needsSaving(boolean flag) {
        if (this.neverSave) {
            return false;
        }
        if (flag ? this.hasEntities && this.worldObj.getWorldTime() != this.lastSaveTime : this.hasEntities && this.worldObj.getWorldTime() >= this.lastSaveTime + 600L) {
            return true;
        }
        return this.isModified;
    }

    public int setChunkData(byte[] abyte0, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int startIndex) {
        ByteBuffer bb = ByteBuffer.allocate(this.blocks.length * 2);
        bb.asShortBuffer().put(this.blocks);
        if (abyte0.length > 65536) {
            this.receivedFromServer = true;
        }
        for (int cX = minX; cX < maxX; ++cX) {
            for (int cZ = minZ; cZ < maxZ; ++cZ) {
                int cIndex = cX << Minecraft.WORLD_HEIGHT_BITS + 4 | cZ << Minecraft.WORLD_HEIGHT_BITS | minY;
                int cY = maxY - minY;
                System.arraycopy(abyte0, startIndex, bb.array(), cIndex * 2, cY * 2);
                startIndex += cY * 2;
            }
        }
        ShortBuffer.wrap(this.blocks).put(bb.asShortBuffer());
        this.generateHeightMap();
        for (int i2 = minX; i2 < maxX; ++i2) {
            for (int i3 = minZ; i3 < maxZ; ++i3) {
                int i4 = i2 << Minecraft.WORLD_HEIGHT_BITS + 4 | i3 << Minecraft.WORLD_HEIGHT_BITS | minY;
                int i5 = maxY - minY;
                System.arraycopy(abyte0, startIndex, this.data.data, i4, i5);
                startIndex += i5;
            }
        }
        for (int j2 = minX; j2 < maxX; ++j2) {
            for (int j3 = minZ; j3 < maxZ; ++j3) {
                int j4 = (j2 << Minecraft.WORLD_HEIGHT_BITS + 4 | j3 << Minecraft.WORLD_HEIGHT_BITS | minY) >> 1;
                int j5 = (maxY - minY) / 2;
                System.arraycopy(abyte0, startIndex, this.blocklightMap.data, j4, j5);
                startIndex += j5;
            }
        }
        for (int k2 = minX; k2 < maxX; ++k2) {
            for (int k3 = minZ; k3 < maxZ; ++k3) {
                int k4 = (k2 << Minecraft.WORLD_HEIGHT_BITS + 4 | k3 << Minecraft.WORLD_HEIGHT_BITS | minY) >> 1;
                int k5 = (maxY - minY) / 2;
                System.arraycopy(abyte0, startIndex, this.skylightMap.data, k4, k5);
                startIndex += k5;
            }
        }
        return startIndex;
    }

    public int getChunkData(byte[] abyte0, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int startIndex) {
        int width = maxX - minX;
        int height = maxY - minY;
        int length = maxZ - minZ;
        ByteBuffer bb = ByteBuffer.allocate(this.blocks.length * 2);
        bb.asShortBuffer().put(this.blocks);
        if (width * height * length == this.blocks.length) {
            System.arraycopy(bb.array(), 0, abyte0, startIndex, this.blocks.length * 2);
            System.arraycopy(this.data.data, 0, abyte0, startIndex += this.blocks.length * 2, this.data.data.length);
            System.arraycopy(this.blocklightMap.data, 0, abyte0, startIndex += this.data.data.length, this.blocklightMap.data.length);
            System.arraycopy(this.skylightMap.data, 0, abyte0, startIndex += this.blocklightMap.data.length, this.skylightMap.data.length);
            return startIndex += this.skylightMap.data.length;
        }
        for (int cX = minX; cX < maxX; ++cX) {
            for (int cZ = minZ; cZ < maxZ; ++cZ) {
                int cIndex = cX << Minecraft.WORLD_HEIGHT_BITS + 4 | cZ << Minecraft.WORLD_HEIGHT_BITS | minY;
                System.arraycopy(bb.array(), cIndex * 2, abyte0, startIndex, height * 2);
                startIndex += height * 2;
            }
        }
        for (int l2 = minX; l2 < maxX; ++l2) {
            for (int l3 = minZ; l3 < maxZ; ++l3) {
                int l4 = l2 << Minecraft.WORLD_HEIGHT_BITS + 4 | l3 << Minecraft.WORLD_HEIGHT_BITS | minY;
                System.arraycopy(this.data.data, l4, abyte0, startIndex, height);
                startIndex += height;
            }
        }
        for (int i3 = minX; i3 < maxX; ++i3) {
            for (int i4 = minZ; i4 < maxZ; ++i4) {
                int i5 = (i3 << Minecraft.WORLD_HEIGHT_BITS + 4 | i4 << Minecraft.WORLD_HEIGHT_BITS | minY) >> 1;
                int i6 = height / 2;
                System.arraycopy(this.blocklightMap.data, i5, abyte0, startIndex, i6);
                startIndex += i6;
            }
        }
        for (int j3 = minX; j3 < maxX; ++j3) {
            for (int j4 = minZ; j4 < maxZ; ++j4) {
                int j5 = (j3 << Minecraft.WORLD_HEIGHT_BITS + 4 | j4 << Minecraft.WORLD_HEIGHT_BITS | minY) >> 1;
                int j6 = height / 2;
                System.arraycopy(this.skylightMap.data, j5, abyte0, startIndex, j6);
                startIndex += j6;
            }
        }
        return startIndex;
    }

    public Random func_997_a(long l) {
        return new Random(this.worldObj.getRandomSeed() + (long)(this.xPosition * this.xPosition * 4987142) + (long)(this.xPosition * 5947611) + (long)(this.zPosition * this.zPosition) * 4392871L + (long)(this.zPosition * 389711) ^ l);
    }

    public boolean func_21167_h() {
        return false;
    }

    public void func_25124_i() {
        ChunkBlockMap.func_26002_a(this.blocks);
    }
}

