/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.shared.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.Chunk;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;
import net.minecraft.src.WorldChunkManager;

public class ChunkCache
implements IBlockAccess {
    private int chunkX;
    private int chunkZ;
    private Chunk[][] chunkArray;
    private World worldObj;

    public ChunkCache(World world, int i, int j, int k, int l, int i1, int j1) {
        this.worldObj = world;
        this.chunkX = i >> 4;
        this.chunkZ = k >> 4;
        int k1 = l >> 4;
        int l1 = j1 >> 4;
        this.chunkArray = new Chunk[k1 - this.chunkX + 1][l1 - this.chunkZ + 1];
        for (int i2 = this.chunkX; i2 <= k1; ++i2) {
            for (int j2 = this.chunkZ; j2 <= l1; ++j2) {
                this.chunkArray[i2 - this.chunkX][j2 - this.chunkZ] = world.getChunkFromChunkCoords(i2, j2);
            }
        }
    }

    @Override
    public int getBlockId(int i, int j, int k) {
        if (j < 0) {
            return 0;
        }
        if (j >= Minecraft.WORLD_HEIGHT_BLOCKS) {
            return 0;
        }
        int l = (i >> 4) - this.chunkX;
        int i1 = (k >> 4) - this.chunkZ;
        if (l < 0 || l >= this.chunkArray.length || i1 < 0 || i1 >= this.chunkArray[l].length) {
            return 0;
        }
        Chunk chunk = this.chunkArray[l][i1];
        if (chunk == null) {
            return 0;
        }
        return chunk.getBlockID(i & 0xF, j, k & 0xF);
    }

    @Override
    public TileEntity getBlockTileEntity(int i, int j, int k) {
        int l = (i >> 4) - this.chunkX;
        int i1 = (k >> 4) - this.chunkZ;
        return this.chunkArray[l][i1].getChunkBlockTileEntity(i & 0xF, j, k & 0xF);
    }

    public boolean getBlockLitInteriorSurface(int i, int j, int k) {
        if (i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return true;
        }
        if (j < 0) {
            return true;
        }
        if (j >= Minecraft.WORLD_HEIGHT_BLOCKS) {
            return true;
        }
        return Block.getIsLitInteriorSurface(this.worldObj, i, j, k);
    }

    @Override
    public float getBrightness(int i, int j, int k, int l) {
        int i1 = this.getLightValue(i, j, k);
        if (i1 < l) {
            i1 = l;
        }
        return this.worldObj.dimension.worldType.worldProvider.lightBrightnessTable[i1];
    }

    @Override
    public float getLightBrightness(int i, int j, int k) {
        return this.worldObj.dimension.worldType.worldProvider.lightBrightnessTable[this.getLightValue(i, j, k)];
    }

    public int getLightValue(int i, int j, int k) {
        return this.getLightValueExt(i, j, k, true);
    }

    public int getLightValueExt(int i, int j, int k, boolean flag) {
        if (i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return 15;
        }
        if (flag && this.getBlockLitInteriorSurface(i, j, k)) {
            int k1 = this.getLightValueExt(i, j + 1, k, false);
            int i2 = this.getLightValueExt(i + 1, j, k, false);
            int j2 = this.getLightValueExt(i - 1, j, k, false);
            int k2 = this.getLightValueExt(i, j, k + 1, false);
            int l2 = this.getLightValueExt(i, j, k - 1, false);
            if (i2 > k1) {
                k1 = i2;
            }
            if (j2 > k1) {
                k1 = j2;
            }
            if (k2 > k1) {
                k1 = k2;
            }
            if (l2 > k1) {
                k1 = l2;
            }
            return k1;
        }
        if (j < 0) {
            return 0;
        }
        if (j >= Minecraft.WORLD_HEIGHT_BLOCKS) {
            int i1 = 15 - this.worldObj.skylightSubtracted;
            if (i1 < 0) {
                i1 = 0;
            }
            return i1;
        }
        int j1 = (i >> 4) - this.chunkX;
        int l1 = (k >> 4) - this.chunkZ;
        return this.chunkArray[j1][l1].getBlockLightValue(i & 0xF, j, k & 0xF, this.worldObj.skylightSubtracted);
    }

    @Override
    public int getBlockMetadata(int i, int j, int k) {
        if (j < 0) {
            return 0;
        }
        if (j >= Minecraft.WORLD_HEIGHT_BLOCKS) {
            return 0;
        }
        int l = (i >> 4) - this.chunkX;
        int i1 = (k >> 4) - this.chunkZ;
        return this.chunkArray[l][i1].getBlockMetadata(i & 0xF, j, k & 0xF);
    }

    @Override
    public Material getBlockMaterial(int i, int j, int k) {
        int l = this.getBlockId(i, j, k);
        if (l == 0) {
            return Material.air;
        }
        return Block.blocksList[l].blockMaterial;
    }

    @Override
    public WorldChunkManager getWorldChunkManager() {
        return this.worldObj.getWorldChunkManager();
    }

    @Override
    public boolean isBlockOpaqueCube(int i, int j, int k) {
        Block block = Block.blocksList[this.getBlockId(i, j, k)];
        if (block == null) {
            return false;
        }
        return block.isOpaqueCube();
    }

    @Override
    public boolean isBlockNormalCube(int i, int j, int k) {
        Block block = Block.blocksList[this.getBlockId(i, j, k)];
        if (block == null) {
            return false;
        }
        return block.blockMaterial.getIsSolid() && block.renderAsNormalBlock();
    }
}

