/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

public class ChunkCoordinates
implements Comparable<ChunkCoordinates> {
    public int x;
    public int y;
    public int z;

    public ChunkCoordinates() {
    }

    public ChunkCoordinates(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public ChunkCoordinates(ChunkCoordinates pos) {
        this.x = pos.x;
        this.y = pos.y;
        this.z = pos.z;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ChunkCoordinates)) {
            return false;
        }
        ChunkCoordinates chunkcoordinates = (ChunkCoordinates)obj;
        return this.x == chunkcoordinates.x && this.y == chunkcoordinates.y && this.z == chunkcoordinates.z;
    }

    public int hashCode() {
        return this.x + this.z << 8 + this.y << 16;
    }

    public int compareChunkCoordinate(ChunkCoordinates chunkcoordinates) {
        if (this.y == chunkcoordinates.y) {
            if (this.z == chunkcoordinates.z) {
                return this.x - chunkcoordinates.x;
            }
            return this.z - chunkcoordinates.z;
        }
        return this.y - chunkcoordinates.y;
    }

    public double getSqDistanceTo(int i, int j, int k) {
        int l = this.x - i;
        int i1 = this.y - j;
        int j1 = this.z - k;
        return Math.sqrt(l * l + i1 * i1 + j1 * j1);
    }

    @Override
    public int compareTo(ChunkCoordinates o) {
        return this.compareChunkCoordinate(o);
    }

    public boolean equals(int x, int y, int z) {
        return this.x == x && this.y == y && this.z == z;
    }
}

