/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Arrays;
import java.util.Random;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.Block;
import net.minecraft.src.BlockSand;
import net.minecraft.src.Chunk;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.IProgressUpdate;
import net.minecraft.src.MapGenBase;
import net.minecraft.src.MapGenCaves;
import net.minecraft.src.Material;
import net.minecraft.src.NoiseGeneratorOctaves;
import net.minecraft.src.World;
import net.minecraft.src.WorldGenCactus;
import net.minecraft.src.WorldGenClay;
import net.minecraft.src.WorldGenDungeon;
import net.minecraft.src.WorldGenFlowers;
import net.minecraft.src.WorldGenLiquids;
import net.minecraft.src.WorldGenMinable;
import net.minecraft.src.WorldGenPumpkin;
import net.minecraft.src.WorldGenReed;
import net.minecraft.src.WorldGenerator;

public class ChunkProviderSky
implements IChunkProvider {
    private Random field_28087_j;
    private NoiseGeneratorOctaves field_28086_k;
    private NoiseGeneratorOctaves field_28085_l;
    private NoiseGeneratorOctaves field_28084_m;
    private NoiseGeneratorOctaves field_28083_n;
    private NoiseGeneratorOctaves field_28082_o;
    public NoiseGeneratorOctaves field_28096_a;
    public NoiseGeneratorOctaves field_28095_b;
    public NoiseGeneratorOctaves field_28094_c;
    private World field_28081_p;
    private double[] field_28080_q;
    private double[] field_28079_r = new double[256];
    private double[] field_28078_s = new double[256];
    private double[] field_28077_t = new double[256];
    private MapGenBase field_28076_u = new MapGenCaves(false);
    private BiomeGenBase[] field_28075_v;
    double[] field_28093_d;
    double[] field_28092_e;
    double[] field_28091_f;
    double[] field_28090_g;
    double[] field_28089_h;
    int[][] field_28088_i = new int[32][32];
    private double[] field_28074_w;

    public ChunkProviderSky(World world, long l) {
        this.field_28081_p = world;
        this.field_28087_j = new Random(l);
        this.field_28086_k = new NoiseGeneratorOctaves(this.field_28087_j, 16);
        this.field_28085_l = new NoiseGeneratorOctaves(this.field_28087_j, 16);
        this.field_28084_m = new NoiseGeneratorOctaves(this.field_28087_j, 8);
        this.field_28083_n = new NoiseGeneratorOctaves(this.field_28087_j, 4);
        this.field_28082_o = new NoiseGeneratorOctaves(this.field_28087_j, 4);
        this.field_28096_a = new NoiseGeneratorOctaves(this.field_28087_j, 10);
        this.field_28095_b = new NoiseGeneratorOctaves(this.field_28087_j, 16);
        this.field_28094_c = new NoiseGeneratorOctaves(this.field_28087_j, 8);
    }

    public int[] generateTerrain(int i, int j, short[] ashort0) {
        int byte0 = 2;
        int[] heights = new int[256];
        Arrays.fill(heights, 0);
        int k = byte0 + 1;
        int byte1 = 33;
        int l = byte0 + 1;
        this.field_28080_q = this.func_28073_a(this.field_28080_q, i * byte0, 0, j * byte0, k, byte1, l);
        for (int x = 0; x < byte0; ++x) {
            for (int z = 0; z < byte0; ++z) {
                for (int y = 0; y < 32; ++y) {
                    double d = 0.25;
                    double d1 = this.field_28080_q[((x + 0) * l + (z + 0)) * byte1 + (y + 0)];
                    double d2 = this.field_28080_q[((x + 0) * l + (z + 1)) * byte1 + (y + 0)];
                    double d3 = this.field_28080_q[((x + 1) * l + (z + 0)) * byte1 + (y + 0)];
                    double d4 = this.field_28080_q[((x + 1) * l + (z + 1)) * byte1 + (y + 0)];
                    double d5 = (this.field_28080_q[((x + 0) * l + (z + 0)) * byte1 + (y + 1)] - d1) * d;
                    double d6 = (this.field_28080_q[((x + 0) * l + (z + 1)) * byte1 + (y + 1)] - d2) * d;
                    double d7 = (this.field_28080_q[((x + 1) * l + (z + 0)) * byte1 + (y + 1)] - d3) * d;
                    double d8 = (this.field_28080_q[((x + 1) * l + (z + 1)) * byte1 + (y + 1)] - d4) * d;
                    for (int l1 = 0; l1 < 4; ++l1) {
                        double d9 = 0.125;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int i2 = 0; i2 < 8; ++i2) {
                            int j2 = i2 + x * 8 << Minecraft.WORLD_HEIGHT_BITS + 4 | 0 + z * 8 << Minecraft.WORLD_HEIGHT_BITS | y * 4 + l1;
                            char c = (char)Minecraft.WORLD_HEIGHT_BLOCKS;
                            double d14 = 0.125;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            for (int k2 = 0; k2 < 8; ++k2) {
                                int l2 = 0;
                                if (d15 > 0.0) {
                                    l2 = Block.stone.blockID;
                                }
                                if (l2 != 0 && y > heights[x * 16 + z]) {
                                    heights[x * 16 + z] = y;
                                }
                                ashort0[j2] = (short)l2;
                                j2 += c;
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
        return heights;
    }

    public void replaceBlocksForBiome(int i, int j, short[] ashort0, BiomeGenBase[] abiomegenbase) {
        double d = 0.03125;
        this.field_28079_r = this.field_28083_n.generateNoiseOctaves(this.field_28079_r, i * 16, j * 16, 0.0, 16, 16, 1, d, d, 1.0);
        this.field_28078_s = this.field_28083_n.generateNoiseOctaves(this.field_28078_s, i * 16, 109.0134, j * 16, 16, 1, 16, d, 1.0, d);
        this.field_28077_t = this.field_28082_o.generateNoiseOctaves(this.field_28077_t, i * 16, j * 16, 0.0, 16, 16, 1, d * 2.0, d * 2.0, d * 2.0);
        for (int k = 0; k < 16; ++k) {
            for (int l = 0; l < 16; ++l) {
                BiomeGenBase biomegenbase = abiomegenbase[k + l * 16];
                int i1 = (int)(this.field_28077_t[k + l * 16] / 3.0 + 3.0 + this.field_28087_j.nextDouble() * 0.25);
                int j1 = -1;
                short short0 = biomegenbase.topBlock;
                short short1 = biomegenbase.fillerBlock;
                for (int k1 = Minecraft.WORLD_HEIGHT_BLOCKS - 1; k1 >= 0; --k1) {
                    int l1 = (l * 16 + k) * Minecraft.WORLD_HEIGHT_BLOCKS + k1;
                    short short2 = ashort0[l1];
                    if (short2 == 0) {
                        j1 = -1;
                        continue;
                    }
                    if (short2 != Block.stone.blockID) continue;
                    if (j1 == -1) {
                        if (i1 <= 0) {
                            short0 = 0;
                            short1 = (short)Block.stone.blockID;
                        }
                        j1 = i1;
                        if (k1 >= 0) {
                            ashort0[l1] = short0;
                            continue;
                        }
                        ashort0[l1] = short1;
                        continue;
                    }
                    if (j1 <= 0) continue;
                    ashort0[l1] = short1;
                    if (--j1 != 0 || short1 != Block.sand.blockID) continue;
                    j1 = this.field_28087_j.nextInt(4);
                    short1 = (short)Block.sandstone.blockID;
                }
            }
        }
    }

    @Override
    public Chunk prepareChunk(int i, int j) {
        return this.provideChunk(i, j);
    }

    @Override
    public Chunk provideChunk(int i, int j) {
        this.field_28087_j.setSeed((long)i * 341873128712L + (long)j * 132897987541L);
        short[] ashort0 = new short[256 * Minecraft.WORLD_HEIGHT_BLOCKS];
        Chunk chunk = new Chunk(this.field_28081_p, ashort0, i, j);
        this.field_28075_v = this.field_28081_p.getWorldChunkManager().loadBlockGeneratorData(this.field_28075_v, i * 16, j * 16, 16, 16);
        this.generateTerrain(i, j, ashort0);
        this.replaceBlocksForBiome(i, j, ashort0, this.field_28075_v);
        this.field_28076_u.generate(this, this.field_28081_p, i, j, ashort0);
        chunk.func_1024_c();
        return chunk;
    }

    private double[] func_28073_a(double[] ad, int i, int j, int k, int l, int i1, int j1) {
        if (ad == null) {
            ad = new double[l * i1 * j1];
        }
        double d = 684.412;
        double d1 = 684.412;
        double[] ad1 = this.field_28081_p.getWorldChunkManager().temperature;
        double[] ad2 = this.field_28081_p.getWorldChunkManager().humidity;
        this.field_28090_g = this.field_28096_a.func_4109_a(this.field_28090_g, i, k, l, j1, 1.121, 1.121, 0.5);
        this.field_28089_h = this.field_28095_b.func_4109_a(this.field_28089_h, i, k, l, j1, 200.0, 200.0, 0.5);
        this.field_28093_d = this.field_28084_m.generateNoiseOctaves(this.field_28093_d, i, j, k, l, i1, j1, (d *= 2.0) / 80.0, d1 / 160.0, d / 80.0);
        this.field_28092_e = this.field_28086_k.generateNoiseOctaves(this.field_28092_e, i, j, k, l, i1, j1, d, d1, d);
        this.field_28091_f = this.field_28085_l.generateNoiseOctaves(this.field_28091_f, i, j, k, l, i1, j1, d, d1, d);
        int k1 = 0;
        int l1 = 0;
        int i2 = 16 / l;
        for (int j2 = 0; j2 < l; ++j2) {
            int k2 = j2 * i2 + i2 / 2;
            for (int l2 = 0; l2 < j1; ++l2) {
                double d6;
                int i3 = l2 * i2 + i2 / 2;
                double d2 = ad1[k2 * 16 + i3];
                double d3 = ad2[k2 * 16 + i3] * d2;
                double d4 = 1.0 - d3;
                d4 *= d4;
                d4 *= d4;
                d4 = 1.0 - d4;
                double d5 = (this.field_28090_g[l1] + 256.0) / 512.0;
                if ((d5 *= d4) > 1.0) {
                    d5 = 1.0;
                }
                if ((d6 = this.field_28089_h[l1] / 8000.0) < 0.0) {
                    d6 = -d6 * 0.3;
                }
                if ((d6 = d6 * 3.0 - 2.0) > 1.0) {
                    d6 = 1.0;
                }
                d6 /= 8.0;
                d6 = 0.0;
                if (d5 < 0.0) {
                    d5 = 0.0;
                }
                d5 += 0.5;
                d6 = d6 * (double)i1 / 16.0;
                ++l1;
                double d7 = (double)i1 / 2.0;
                for (int j3 = 0; j3 < i1; ++j3) {
                    double d8 = 0.0;
                    double d9 = ((double)j3 - d7) * 8.0 / d5;
                    if (d9 < 0.0) {
                        d9 *= -1.0;
                    }
                    double d10 = this.field_28092_e[k1] / 512.0;
                    double d11 = this.field_28091_f[k1] / 512.0;
                    double d12 = (this.field_28093_d[k1] / 10.0 + 1.0) / 2.0;
                    d8 = d12 < 0.0 ? d10 : (d12 > 1.0 ? d11 : d10 + (d11 - d10) * d12);
                    d8 -= 8.0;
                    int k3 = 32;
                    if (j3 > i1 - k3) {
                        double d13 = (float)(j3 - (i1 - k3)) / ((float)k3 - 1.0f);
                        d8 = d8 * (1.0 - d13) + -30.0 * d13;
                    }
                    if (j3 < (k3 = 8)) {
                        double d14 = (float)(k3 - j3) / ((float)k3 - 1.0f);
                        d8 = d8 * (1.0 - d14) + -30.0 * d14;
                    }
                    ad[k1] = d8;
                    ++k1;
                }
            }
        }
        return ad;
    }

    @Override
    public boolean chunkExists(int i, int j) {
        return true;
    }

    @Override
    public void populate(IChunkProvider ichunkprovider, int i, int j) {
        BlockSand.fallInstantly = true;
        int k = i * 16;
        int l = j * 16;
        BiomeGenBase biomegenbase = this.field_28081_p.getWorldChunkManager().getBiomeGenAt(k + 16, l + 16);
        this.field_28087_j.setSeed(this.field_28081_p.getRandomSeed());
        long l1 = this.field_28087_j.nextLong() / 2L * 2L + 1L;
        long l2 = this.field_28087_j.nextLong() / 2L * 2L + 1L;
        this.field_28087_j.setSeed((long)i * l1 + (long)j * l2 ^ this.field_28081_p.getRandomSeed());
        double d = 0.25;
        for (int k1 = 0; k1 < 8; ++k1) {
            int j5 = k + this.field_28087_j.nextInt(16) + 8;
            int k8 = this.field_28087_j.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int i13 = l + this.field_28087_j.nextInt(16) + 8;
            new WorldGenDungeon(Block.cobbleStone.blockID, Block.cobbleStoneMossy.blockID, null).generate(this.field_28081_p, this.field_28087_j, j5, k8, i13);
        }
        for (int i2 = 0; i2 < 10; ++i2) {
            int k5 = k + this.field_28087_j.nextInt(16);
            int l8 = this.field_28087_j.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int j13 = l + this.field_28087_j.nextInt(16);
            new WorldGenClay(32).generate(this.field_28081_p, this.field_28087_j, k5, l8, j13);
        }
        for (int j2 = 0; j2 < 20; ++j2) {
            int l5 = k + this.field_28087_j.nextInt(16);
            int i9 = this.field_28087_j.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int k13 = l + this.field_28087_j.nextInt(16);
            new WorldGenMinable(Block.dirt.blockID, 32, false).generate(this.field_28081_p, this.field_28087_j, l5, i9, k13);
        }
        for (int k2 = 0; k2 < 10; ++k2) {
            int i6 = k + this.field_28087_j.nextInt(16);
            int j9 = this.field_28087_j.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int l13 = l + this.field_28087_j.nextInt(16);
            new WorldGenMinable(Block.gravel.blockID, 32, false).generate(this.field_28081_p, this.field_28087_j, i6, j9, l13);
        }
        for (int i3 = 0; i3 < 20; ++i3) {
            int j6 = k + this.field_28087_j.nextInt(16);
            int k9 = this.field_28087_j.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int i14 = l + this.field_28087_j.nextInt(16);
            new WorldGenMinable(Block.oreCoalStone.blockID, 16, true).generate(this.field_28081_p, this.field_28087_j, j6, k9, i14);
        }
        for (int j3 = 0; j3 < 20; ++j3) {
            int k6 = k + this.field_28087_j.nextInt(16);
            int l9 = this.field_28087_j.nextInt(64);
            int j14 = l + this.field_28087_j.nextInt(16);
            new WorldGenMinable(Block.oreIronStone.blockID, 8, true).generate(this.field_28081_p, this.field_28087_j, k6, l9, j14);
        }
        for (int k3 = 0; k3 < 2; ++k3) {
            int l6 = k + this.field_28087_j.nextInt(16);
            int i10 = this.field_28087_j.nextInt(32);
            int k14 = l + this.field_28087_j.nextInt(16);
            new WorldGenMinable(Block.oreGoldStone.blockID, 8, true).generate(this.field_28081_p, this.field_28087_j, l6, i10, k14);
        }
        for (int l3 = 0; l3 < 8; ++l3) {
            int i7 = k + this.field_28087_j.nextInt(16);
            int j10 = this.field_28087_j.nextInt(16);
            int l14 = l + this.field_28087_j.nextInt(16);
            new WorldGenMinable(Block.oreRedstoneStone.blockID, 7, true).generate(this.field_28081_p, this.field_28087_j, i7, j10, l14);
        }
        for (int i4 = 0; i4 < 1; ++i4) {
            int j7 = k + this.field_28087_j.nextInt(16);
            int k10 = this.field_28087_j.nextInt(16);
            int i15 = l + this.field_28087_j.nextInt(16);
            new WorldGenMinable(Block.oreDiamondStone.blockID, 7, true).generate(this.field_28081_p, this.field_28087_j, j7, k10, i15);
        }
        for (int j4 = 0; j4 < 1; ++j4) {
            int k7 = k + this.field_28087_j.nextInt(16);
            int l10 = this.field_28087_j.nextInt(16) + this.field_28087_j.nextInt(16);
            int j15 = l + this.field_28087_j.nextInt(16);
            new WorldGenMinable(Block.oreLapisStone.blockID, 6, true).generate(this.field_28081_p, this.field_28087_j, k7, l10, j15);
        }
        d = 0.5;
        int k4 = (int)((this.field_28094_c.func_806_a((double)k * d, (double)l * d) / 8.0 + this.field_28087_j.nextDouble() * 4.0 + 4.0) / 3.0);
        int l7 = 0;
        if (this.field_28087_j.nextInt(10) == 0) {
            ++l7;
        }
        if (biomegenbase == BiomeGenBase.forest) {
            l7 += k4 + 5;
        }
        if (biomegenbase == BiomeGenBase.rainforest) {
            l7 += k4 + 5;
        }
        if (biomegenbase == BiomeGenBase.seasonalForest) {
            l7 += k4 + 2;
        }
        if (biomegenbase == BiomeGenBase.taiga) {
            l7 += k4 + 5;
        }
        if (biomegenbase == BiomeGenBase.desert) {
            l7 -= 20;
        }
        if (biomegenbase == BiomeGenBase.tundra) {
            l7 -= 20;
        }
        if (biomegenbase == BiomeGenBase.plains) {
            l7 -= 20;
        }
        for (int i11 = 0; i11 < l7; ++i11) {
            int k15 = k + this.field_28087_j.nextInt(16) + 8;
            int j18 = l + this.field_28087_j.nextInt(16) + 8;
            WorldGenerator worldgenerator = biomegenbase.getRandomWorldGenForTrees(this.field_28087_j);
            worldgenerator.func_517_a(1.0, 1.0, 1.0);
            worldgenerator.generate(this.field_28081_p, this.field_28087_j, k15, this.field_28081_p.getHeightValue(k15, j18), j18);
        }
        for (int j11 = 0; j11 < 2; ++j11) {
            int l15 = k + this.field_28087_j.nextInt(16) + 8;
            int k18 = this.field_28087_j.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int i21 = l + this.field_28087_j.nextInt(16) + 8;
            new WorldGenFlowers(Block.flowerYellow.blockID).generate(this.field_28081_p, this.field_28087_j, l15, k18, i21);
        }
        if (this.field_28087_j.nextInt(2) == 0) {
            int k11 = k + this.field_28087_j.nextInt(16) + 8;
            int i16 = this.field_28087_j.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int l18 = l + this.field_28087_j.nextInt(16) + 8;
            new WorldGenFlowers(Block.flowerRed.blockID).generate(this.field_28081_p, this.field_28087_j, k11, i16, l18);
        }
        if (this.field_28087_j.nextInt(4) == 0) {
            int l11 = k + this.field_28087_j.nextInt(16) + 8;
            int j16 = this.field_28087_j.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int i19 = l + this.field_28087_j.nextInt(16) + 8;
            new WorldGenFlowers(Block.mushroomBrown.blockID).generate(this.field_28081_p, this.field_28087_j, l11, j16, i19);
        }
        if (this.field_28087_j.nextInt(8) == 0) {
            int i12 = k + this.field_28087_j.nextInt(16) + 8;
            int k16 = this.field_28087_j.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int j19 = l + this.field_28087_j.nextInt(16) + 8;
            new WorldGenFlowers(Block.mushroomRed.blockID).generate(this.field_28081_p, this.field_28087_j, i12, k16, j19);
        }
        for (int j12 = 0; j12 < 10; ++j12) {
            int l16 = k + this.field_28087_j.nextInt(16) + 8;
            int k19 = this.field_28087_j.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int j21 = l + this.field_28087_j.nextInt(16) + 8;
            new WorldGenReed().generate(this.field_28081_p, this.field_28087_j, l16, k19, j21);
        }
        if (this.field_28087_j.nextInt(32) == 0) {
            int k12 = k + this.field_28087_j.nextInt(16) + 8;
            int i17 = this.field_28087_j.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int l19 = l + this.field_28087_j.nextInt(16) + 8;
            new WorldGenPumpkin().generate(this.field_28081_p, this.field_28087_j, k12, i17, l19);
        }
        int l12 = 0;
        if (biomegenbase == BiomeGenBase.desert) {
            l12 += 10;
        }
        for (int j17 = 0; j17 < l12; ++j17) {
            int i20 = k + this.field_28087_j.nextInt(16) + 8;
            int k21 = this.field_28087_j.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int k22 = l + this.field_28087_j.nextInt(16) + 8;
            new WorldGenCactus().generate(this.field_28081_p, this.field_28087_j, i20, k21, k22);
        }
        for (int k17 = 0; k17 < 50; ++k17) {
            int j20 = k + this.field_28087_j.nextInt(16) + 8;
            int l21 = this.field_28087_j.nextInt(this.field_28087_j.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS - 8) + 8);
            int l22 = l + this.field_28087_j.nextInt(16) + 8;
            new WorldGenLiquids(Block.fluidWaterFlowing.blockID).generate(this.field_28081_p, this.field_28087_j, j20, l21, l22);
        }
        for (int l17 = 0; l17 < 20; ++l17) {
            int k20 = k + this.field_28087_j.nextInt(16) + 8;
            int i22 = this.field_28087_j.nextInt(this.field_28087_j.nextInt(this.field_28087_j.nextInt(112) + 8) + 8);
            int i23 = l + this.field_28087_j.nextInt(16) + 8;
            new WorldGenLiquids(Block.fluidLavaFlowing.blockID).generate(this.field_28081_p, this.field_28087_j, k20, i22, i23);
        }
        this.field_28074_w = this.field_28081_p.getWorldChunkManager().getTemperatures(this.field_28074_w, k + 8, l + 8, 16, 16);
        for (int i18 = k + 8; i18 < k + 8 + 16; ++i18) {
            for (int l20 = l + 8; l20 < l + 8 + 16; ++l20) {
                int j22 = i18 - (k + 8);
                int j23 = l20 - (l + 8);
                int k23 = this.field_28081_p.findTopSolidBlock(i18, l20);
                double d1 = this.field_28074_w[j22 * 16 + j23] - (double)(k23 - 64) / 64.0 * 0.3;
                if (!(d1 < 0.5) || k23 <= 0 || k23 >= Minecraft.WORLD_HEIGHT_BLOCKS || !this.field_28081_p.isAirBlock(i18, k23, l20) || !this.field_28081_p.getBlockMaterial(i18, k23 - 1, l20).getIsSolid() || this.field_28081_p.getBlockMaterial(i18, k23 - 1, l20) == Material.ice) continue;
                this.field_28081_p.setBlockWithNotify(i18, k23, l20, Block.layerSnow.blockID);
            }
        }
        BlockSand.fallInstantly = false;
    }

    @Override
    public boolean saveChunks(boolean flag, IProgressUpdate iprogressupdate) {
        return true;
    }

    @Override
    public boolean unload100OldestChunks() {
        return false;
    }

    @Override
    public void unloadAllChunks() {
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    public String makeString() {
        return "RandomLevelSource";
    }

    @Override
    public void checkForMissingChunks() {
    }
}

