/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Entity;
import net.minecraft.src.EntityLightningBolt;
import net.minecraft.src.EntityMob;
import net.minecraft.src.EntitySkeleton;
import net.minecraft.src.Item;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.World;

public class EntityCreeper
extends EntityMob {
    int timeSinceIgnited;
    int lastActiveTime;

    public EntityCreeper(World world) {
        super(world);
        this.texture = "/mob/creeper.png";
        this.scoreValue = 800;
        this.setSize(0.6f, 1.6f);
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (byte)-1);
        this.dataWatcher.addObject(17, (byte)0);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
        if (this.dataWatcher.getWatchableObjectByte(17) == 1) {
            nbttagcompound.setBoolean("powered", true);
        }
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
        this.dataWatcher.updateObject(17, (byte)(nbttagcompound.getBoolean("powered") ? 1 : 0));
    }

    @Override
    protected void attackBlockedEntity(Entity entity, float f) {
        if (this.worldObj.isMultiplayerAndNotHost) {
            return;
        }
        if (this.timeSinceIgnited > 0) {
            this.setCreeperState(-1);
            --this.timeSinceIgnited;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
        }
    }

    @Override
    public void onUpdate() {
        this.lastActiveTime = this.timeSinceIgnited;
        if (this.worldObj.isMultiplayerAndNotHost) {
            int i = this.getCreeperState();
            if (i > 0 && this.timeSinceIgnited == 0) {
                this.worldObj.playSoundAtEntity(this, "random.fuse", 1.0f, 0.5f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= 30) {
                this.timeSinceIgnited = 30;
            }
        }
        super.onUpdate();
    }

    @Override
    protected String getHurtSound() {
        return "mob.creeper";
    }

    @Override
    protected String getDeathSound() {
        return "mob.creeperdeath";
    }

    @Override
    public void onDeath(Entity entity) {
        super.onDeath(entity);
        if (entity instanceof EntitySkeleton) {
            this.dropItem(Item.record13.itemID + this.rand.nextInt(11), 1);
        }
    }

    @Override
    protected void attackEntity(Entity entity, float f) {
        if (this.worldObj.isMultiplayerAndNotHost) {
            return;
        }
        int i = this.getCreeperState();
        if (i <= 0 && f < 3.0f || i > 0 && f < 7.0f) {
            if (this.timeSinceIgnited == 0) {
                this.worldObj.playSoundAtEntity(this, "random.fuse", 1.0f, 0.5f);
            }
            this.setCreeperState(1);
            ++this.timeSinceIgnited;
            if (this.timeSinceIgnited >= 30) {
                if (this.getPowered()) {
                    this.worldObj.createExplosion(this, this.posX, this.posY, this.posZ, 6.0f);
                } else {
                    this.worldObj.createExplosion(this, this.posX, this.posY, this.posZ, 3.0f);
                }
                this.setEntityDead();
            }
            this.hasAttacked = true;
        } else {
            this.setCreeperState(-1);
            --this.timeSinceIgnited;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
        }
    }

    public boolean getPowered() {
        return this.dataWatcher.getWatchableObjectByte(17) == 1;
    }

    public float setCreeperFlashTime(float f) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * f) / 28.0f;
    }

    @Override
    protected int getDropItemId() {
        return Item.sulphur.itemID;
    }

    private int getCreeperState() {
        return this.dataWatcher.getWatchableObjectByte(16);
    }

    private void setCreeperState(int i) {
        this.dataWatcher.updateObject(16, (byte)i);
    }

    @Override
    public void onStruckByLightning(EntityLightningBolt entitylightningbolt) {
        super.onStruckByLightning(entitylightningbolt);
        this.dataWatcher.updateObject(17, (byte)1);
    }
}

