/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EnumArt;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.World;
import net.minecraft.src.helper.DamageType;

public class EntityPainting
extends Entity {
    private int field_695_c = 0;
    public int direction = 0;
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public EnumArt art;

    public EntityPainting(World world) {
        super(world);
        this.yOffset = 0.0f;
        this.setSize(0.5f, 0.5f);
    }

    public EntityPainting(World world, int i, int j, int k, int l) {
        this(world);
        this.xPosition = i;
        this.yPosition = j;
        this.zPosition = k;
        ArrayList<EnumArt> arraylist = new ArrayList<EnumArt>();
        EnumArt[] aenumart = EnumArt.values();
        int i1 = aenumart.length;
        for (int j1 = 0; j1 < i1; ++j1) {
            EnumArt enumart;
            this.art = enumart = aenumart[j1];
            this.func_412_b(l);
            if (!this.func_410_i()) continue;
            arraylist.add(enumart);
        }
        if (arraylist.size() > 0) {
            this.art = (EnumArt)((Object)arraylist.get(this.rand.nextInt(arraylist.size())));
        }
        this.func_412_b(l);
    }

    public EntityPainting(World world, int i, int j, int k, int l, String s) {
        this(world);
        this.xPosition = i;
        this.yPosition = j;
        this.zPosition = k;
        for (EnumArt enumart : EnumArt.values()) {
            if (!enumart.title.equals(s)) continue;
            this.art = enumart;
            break;
        }
        this.func_412_b(l);
    }

    @Override
    protected void entityInit() {
    }

    public void func_412_b(int i) {
        this.direction = i;
        this.prevRotationYaw = this.rotationYaw = (float)(i * 90);
        float f = this.art.sizeX;
        float f1 = this.art.sizeY;
        float f2 = this.art.sizeX;
        if (i == 0 || i == 2) {
            f2 = 0.5f;
        } else {
            f = 0.5f;
        }
        f /= 32.0f;
        f1 /= 32.0f;
        f2 /= 32.0f;
        float f3 = (float)this.xPosition + 0.5f;
        float f4 = (float)this.yPosition + 0.5f;
        float f5 = (float)this.zPosition + 0.5f;
        float f6 = 0.5625f;
        if (i == 0) {
            f5 -= f6;
        }
        if (i == 1) {
            f3 -= f6;
        }
        if (i == 2) {
            f5 += f6;
        }
        if (i == 3) {
            f3 += f6;
        }
        if (i == 0) {
            f3 -= this.func_411_c(this.art.sizeX);
        }
        if (i == 1) {
            f5 += this.func_411_c(this.art.sizeX);
        }
        if (i == 2) {
            f3 += this.func_411_c(this.art.sizeX);
        }
        if (i == 3) {
            f5 -= this.func_411_c(this.art.sizeX);
        }
        this.setPosition(f3, f4 += this.func_411_c(this.art.sizeY), f5);
        float f7 = -0.00625f;
        this.boundingBox.setBounds(f3 - f - f7, f4 - f1 - f7, f5 - f2 - f7, f3 + f + f7, f4 + f1 + f7, f5 + f2 + f7);
    }

    private float func_411_c(int i) {
        if (i == 32) {
            return 0.5f;
        }
        return i != 64 ? 0.0f : 0.5f;
    }

    @Override
    public void onUpdate() {
        if (this.field_695_c++ == 100 && !this.worldObj.isMultiplayerAndNotHost) {
            this.field_695_c = 0;
            if (!this.func_410_i()) {
                this.setEntityDead();
                this.worldObj.entityJoinedWorld(new EntityItem(this.worldObj, this.posX, this.posY, this.posZ, new ItemStack(Item.painting)));
            }
        }
    }

    public boolean func_410_i() {
        if (this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox).size() > 0) {
            return false;
        }
        int i = this.art.sizeX / 16;
        int j = this.art.sizeY / 16;
        int k = this.xPosition;
        int l = this.yPosition;
        int i1 = this.zPosition;
        if (this.direction == 0) {
            k = MathHelper.floor_double(this.posX - (double)((float)this.art.sizeX / 32.0f));
        }
        if (this.direction == 1) {
            i1 = MathHelper.floor_double(this.posZ - (double)((float)this.art.sizeX / 32.0f));
        }
        if (this.direction == 2) {
            k = MathHelper.floor_double(this.posX - (double)((float)this.art.sizeX / 32.0f));
        }
        if (this.direction == 3) {
            i1 = MathHelper.floor_double(this.posZ - (double)((float)this.art.sizeX / 32.0f));
        }
        l = MathHelper.floor_double(this.posY - (double)((float)this.art.sizeY / 32.0f));
        for (int j1 = 0; j1 < i; ++j1) {
            for (int k1 = 0; k1 < j; ++k1) {
                Material material = this.direction == 0 || this.direction == 2 ? this.worldObj.getBlockMaterial(k + j1, l + k1, this.zPosition) : this.worldObj.getBlockMaterial(this.xPosition, l + k1, i1 + j1);
                if (material.isSolid()) continue;
                return false;
            }
        }
        List<Entity> list = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox);
        for (int l1 = 0; l1 < list.size(); ++l1) {
            if (!(list.get(l1) instanceof EntityPainting)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canBeCollidedWith() {
        return true;
    }

    @Override
    public boolean attackEntityFrom(Entity entity, int i, DamageType type) {
        if (!this.isDead && !this.worldObj.isMultiplayerAndNotHost) {
            this.setEntityDead();
            this.setBeenAttacked();
            this.worldObj.entityJoinedWorld(new EntityItem(this.worldObj, this.posX, this.posY, this.posZ, new ItemStack(Item.painting)));
        }
        return true;
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setByte("Dir", (byte)this.direction);
        nbttagcompound.setString("Motive", this.art.title);
        nbttagcompound.setInteger("TileX", this.xPosition);
        nbttagcompound.setInteger("TileY", this.yPosition);
        nbttagcompound.setInteger("TileZ", this.zPosition);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        this.direction = nbttagcompound.getByte("Dir");
        this.xPosition = nbttagcompound.getInteger("TileX");
        this.yPosition = nbttagcompound.getInteger("TileY");
        this.zPosition = nbttagcompound.getInteger("TileZ");
        String s = nbttagcompound.getString("Motive");
        for (EnumArt enumart : EnumArt.values()) {
            if (!enumart.title.equals(s)) continue;
            this.art = enumart;
        }
        if (this.art == null) {
            this.art = EnumArt.Kebab;
        }
        this.func_412_b(this.direction);
    }

    @Override
    public void moveEntity(double d, double d1, double d2) {
        if (!this.worldObj.isMultiplayerAndNotHost && d * d + d1 * d1 + d2 * d2 > 0.0) {
            this.setEntityDead();
            this.worldObj.entityJoinedWorld(new EntityItem(this.worldObj, this.posX, this.posY, this.posZ, new ItemStack(Item.painting)));
        }
    }

    @Override
    public void addVelocity(double d, double d1, double d2) {
        if (!this.worldObj.isMultiplayerAndNotHost && d * d + d1 * d1 + d2 * d2 > 0.0) {
            this.setEntityDead();
            this.worldObj.entityJoinedWorld(new EntityItem(this.worldObj, this.posX, this.posY, this.posZ, new ItemStack(Item.painting)));
        }
    }
}

