/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.shared.Minecraft;
import net.minecraft.src.EntityFX;
import net.minecraft.src.Item;
import net.minecraft.src.Tessellator;
import net.minecraft.src.World;

public class EntitySlimeChunkFX
extends EntityFX {
    public EntitySlimeChunkFX(World world, double d, double d1, double d2, Item item) {
        super(world, d, d1, d2, 0.0, 0.0, 0.0);
        this.particleTextureIndex = item.getIconFromDamage(0);
        this.particleGravity = 2.0f;
        this.particleBlue = 1.0f;
        this.particleGreen = 1.0f;
        this.particleRed = 1.0f;
        this.particleScale /= 2.0f;
        this.particleMaxAge = 50;
    }

    @Override
    public int getFXLayer() {
        return 2;
    }

    @Override
    public void renderParticle(Tessellator tessellator, float f, float f1, float f2, float f3, float f4, float f5) {
        float f6 = ((float)(this.particleTextureIndex % Minecraft.TEXTURE_ATLAS_WIDTH_TILES) + this.particleTextureJitterX / 4.0f) / (float)Minecraft.TEXTURE_ATLAS_WIDTH_TILES;
        float f7 = f6 + 0.25f / (float)Minecraft.TEXTURE_ATLAS_WIDTH_TILES;
        float f8 = ((float)(this.particleTextureIndex / Minecraft.TEXTURE_ATLAS_WIDTH_TILES) + this.particleTextureJitterY / 4.0f) / (float)Minecraft.TEXTURE_ATLAS_WIDTH_TILES;
        float f9 = f8 + 0.25f / (float)Minecraft.TEXTURE_ATLAS_WIDTH_TILES;
        float f10 = 0.1f * this.particleScale;
        float f11 = (float)(this.prevPosX + (this.posX - this.prevPosX) * (double)f - interpPosX);
        float f12 = (float)(this.prevPosY + (this.posY - this.prevPosY) * (double)f - interpPosY);
        float f13 = (float)(this.prevPosZ + (this.posZ - this.prevPosZ) * (double)f - interpPosZ);
        float f14 = this.getEntityBrightness(f);
        tessellator.setColorOpaque_F(f14 * this.particleRed, f14 * this.particleGreen, f14 * this.particleBlue);
        tessellator.addVertexWithUV(f11 - f1 * f10 - f4 * f10, f12 - f2 * f10, f13 - f3 * f10 - f5 * f10, f6, f9);
        tessellator.addVertexWithUV(f11 - f1 * f10 + f4 * f10, f12 + f2 * f10, f13 - f3 * f10 + f5 * f10, f6, f8);
        tessellator.addVertexWithUV(f11 + f1 * f10 + f4 * f10, f12 + f2 * f10, f13 + f3 * f10 + f5 * f10, f7, f8);
        tessellator.addVertexWithUV(f11 + f1 * f10 - f4 * f10, f12 - f2 * f10, f13 + f3 * f10 - f5 * f10, f7, f9);
    }
}

