/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.ChatAllowedCharacters;
import net.minecraft.src.Dimension;
import net.minecraft.src.Gamemode;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.GuiTextField;
import net.minecraft.src.ISaveFormat;
import net.minecraft.src.MathHelper;
import net.minecraft.src.PlayerControllerSP;
import net.minecraft.src.StringTranslate;
import net.minecraft.src.WorldType;
import org.lwjgl.input.Keyboard;

public class GuiCreateWorld
extends GuiScreen {
    private GuiScreen field_22131_a;
    private GuiTextField textboxWorldName;
    private GuiTextField textboxSeed;
    private GuiButton createWorldButton;
    private GuiButton gamemodeButton;
    private GuiButton cheatsButton;
    private GuiButton worldTypeButton;
    private String folderName;
    private boolean createClicked;
    private Gamemode selectedGamemode = Gamemode.survival;
    private boolean cheatsEnabled = false;
    private int worldType = 0;
    private WorldType[] worldTypes = new WorldType[]{WorldType.overworldDeeper, WorldType.overworld, WorldType.overworldWinter, WorldType.overworldIslands, WorldType.overworldFlat, WorldType.overworldHell, WorldType.overworldWoods, WorldType.overworldParadise, WorldType.overworldRetro};

    public GuiCreateWorld(GuiScreen guiscreen) {
        this.field_22131_a = guiscreen;
    }

    @Override
    public void updateScreen() {
        this.textboxWorldName.updateCursorCounter();
        this.textboxSeed.updateCursorCounter();
    }

    @Override
    public void initGui() {
        StringTranslate stringtranslate = StringTranslate.getInstance();
        Keyboard.enableRepeatEvents((boolean)true);
        this.controlList.clear();
        this.createWorldButton = new GuiButton(0, this.width / 2 - 100, this.height / 4 + 104 + 12, stringtranslate.translateKey("selectWorld.create"));
        this.controlList.add(this.createWorldButton);
        this.controlList.add(new GuiButton(1, this.width / 2 - 100, this.height / 4 + 128 + 12, stringtranslate.translateKey("gui.cancel")));
        this.textboxWorldName = new GuiTextField(this, this.fontRenderer, this.width / 2 - 100, 60, 200, 20, stringtranslate.translateKey("selectWorld.newWorld"));
        this.textboxWorldName.isFocused = true;
        this.textboxWorldName.setMaxStringLength(32);
        this.textboxSeed = new GuiTextField(this, this.fontRenderer, this.width / 2 - 100, 100, 200, 20, "");
        this.gamemodeButton = new GuiButton(2, this.width / 2 - 100, 124, 98, 20, stringtranslate.translateKey("selectWorld.gamemode") + " " + stringtranslate.translateNamedKey(this.selectedGamemode.languageKey));
        this.controlList.add(this.gamemodeButton);
        this.cheatsButton = new GuiButton(3, this.width / 2 - 100 + 102, 124, 98, 20, stringtranslate.translateKey("selectWorld.cheats") + " " + stringtranslate.translateKey(this.cheatsEnabled ? "options.on" : "options.off"));
        this.controlList.add(this.cheatsButton);
        this.worldTypeButton = new GuiButton(4, this.width / 2 - 100, 148, stringtranslate.translateKey("selectWorld.worldType") + " " + stringtranslate.translateNamedKey(this.worldTypes[this.worldType].languageKey));
        this.controlList.add(this.worldTypeButton);
        this.createWorldButton.enabled = this.worldTypes[this.worldType].worldProvider != null;
        this.func_22129_j();
    }

    private void func_22129_j() {
        this.folderName = this.textboxWorldName.getText().trim();
        for (char c : ChatAllowedCharacters.allowedCharactersArray) {
            this.folderName = this.folderName.replace(c, '_');
        }
        if (MathHelper.stringNullOrLengthZero(this.folderName)) {
            this.folderName = "World";
        }
        this.folderName = GuiCreateWorld.generateUnusedFolderName(this.mc.getSaveLoader(), this.folderName);
    }

    public static String generateUnusedFolderName(ISaveFormat isaveformat, String s) {
        int count = 1;
        String newString = s;
        while (isaveformat.getWorldInfo(newString) != null) {
            newString = s + " (" + count + ")";
            ++count;
        }
        return newString;
    }

    @Override
    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    protected void actionPerformed(GuiButton guibutton) {
        if (!guibutton.enabled) {
            return;
        }
        if (guibutton.id == 1) {
            this.mc.displayGuiScreen(this.field_22131_a);
        } else if (guibutton.id == 0) {
            this.mc.displayGuiScreen(null);
            if (this.createClicked) {
                return;
            }
            this.createClicked = true;
            long l = new Random().nextLong();
            String s = this.textboxSeed.getText();
            if (!MathHelper.stringNullOrLengthZero(s)) {
                try {
                    long l1 = Long.parseLong(s);
                    if (l1 != 0L) {
                        l = l1;
                    }
                }
                catch (NumberFormatException numberformatexception) {
                    l = s.hashCode();
                }
            }
            Dimension.overworld.setWorldType(this.worldTypes[this.worldType]);
            this.mc.playerController = new PlayerControllerSP(this.mc);
            this.mc.startWorld(this.folderName, this.textboxWorldName.getText(), l);
            this.mc.thePlayer.setGamemode(this.selectedGamemode);
            this.mc.theWorld.getWorldInfo().setCheatsEnabled(this.cheatsEnabled);
            this.mc.displayGuiScreen(null);
        } else if (guibutton == this.gamemodeButton) {
            StringTranslate stringtranslate = StringTranslate.getInstance();
            this.selectedGamemode = Gamemode.gamemodesList[(this.selectedGamemode.id + 1) % Gamemode.gamemodesList.length];
            this.gamemodeButton.displayString = stringtranslate.translateKey("selectWorld.gamemode") + " " + stringtranslate.translateNamedKey(this.selectedGamemode.languageKey);
            this.cheatsEnabled = this.selectedGamemode == Gamemode.creative;
            this.cheatsButton.displayString = stringtranslate.translateKey("selectWorld.cheats") + " " + stringtranslate.translateKey(this.cheatsEnabled ? "options.on" : "options.off");
        } else if (guibutton == this.cheatsButton) {
            StringTranslate stringtranslate = StringTranslate.getInstance();
            this.cheatsEnabled = !this.cheatsEnabled;
            this.cheatsButton.displayString = stringtranslate.translateKey("selectWorld.cheats") + " " + stringtranslate.translateKey(this.cheatsEnabled ? "options.on" : "options.off");
        } else if (guibutton == this.worldTypeButton) {
            StringTranslate stringtranslate = StringTranslate.getInstance();
            this.worldType = (this.worldType + 1) % this.worldTypes.length;
            this.worldTypeButton.displayString = stringtranslate.translateKey("selectWorld.worldType") + " " + stringtranslate.translateNamedKey(this.worldTypes[this.worldType].languageKey);
            this.createWorldButton.enabled = this.worldTypes[this.worldType].worldProvider != null;
        }
    }

    @Override
    public void keyTyped(char c, int i) {
        if (i != 14) {
            super.keyTyped(c, i);
        }
        if (this.textboxWorldName.isFocused) {
            this.textboxWorldName.textboxKeyTyped(c, i);
        } else {
            this.textboxSeed.textboxKeyTyped(c, i);
        }
        if (c == '\r') {
            this.actionPerformed((GuiButton)this.controlList.get(0));
        }
        ((GuiButton)this.controlList.get((int)0)).enabled = this.textboxWorldName.getText().length() > 0 && this.worldTypes[this.worldType].worldProvider != null;
        this.func_22129_j();
    }

    @Override
    public void mouseClicked(int x, int y, int button) {
        super.mouseClicked(x, y, button);
        this.textboxWorldName.mouseClicked(x, y, button);
        this.textboxSeed.mouseClicked(x, y, button);
    }

    @Override
    public void drawScreen(int x, int y, float renderPartialTicks) {
        StringTranslate stringtranslate = StringTranslate.getInstance();
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRenderer, stringtranslate.translateKey("selectWorld.create"), this.width / 2, this.height / 4 - 60 + 20, 0xFFFFFF);
        this.drawString(this.fontRenderer, stringtranslate.translateKey("selectWorld.enterName"), this.width / 2 - 100, 47, 0xA0A0A0);
        this.drawString(this.fontRenderer, stringtranslate.translateKey("selectWorld.enterSeed"), this.width / 2 - 100, 88, 0xA0A0A0);
        this.textboxWorldName.drawTextBox();
        this.textboxSeed.drawTextBox();
        super.drawScreen(x, y, renderPartialTicks);
    }

    @Override
    public void selectNextField() {
        if (this.textboxWorldName.isFocused) {
            this.textboxWorldName.setFocused(false);
            this.textboxSeed.setFocused(true);
        } else {
            this.textboxWorldName.setFocused(true);
            this.textboxSeed.setFocused(false);
        }
    }
}

