/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.awt.Desktop;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.src.Block;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiClickableLabel;
import net.minecraft.src.GuiOptions;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.GuiSelectServer;
import net.minecraft.src.GuiSelectWorld;
import net.minecraft.src.GuiTexturePacks;
import net.minecraft.src.LogoEffectRandomizer;
import net.minecraft.src.MathHelper;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.StringTranslate;
import net.minecraft.src.Tessellator;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class GuiMainMenu
extends GuiScreen {
    private static final Random rand = new Random();
    private static float backgroundCounter = 0.0f;
    private static float currentBackgroundAlpha = 1.0f;
    private static boolean drawNextBg = false;
    private String splashText = "missingno";
    private GuiButton multiplayerButton;
    private static int currentBg = -1;
    private static int nextBg = -1;
    private static final int bgCount = 30;
    private static String[] logoBlockLayers = null;
    private LogoEffectRandomizer[][] logoEffects;
    private boolean shouldDrawOldLogo = false;
    private int logoClickCounter = 0;

    public GuiMainMenu() {
        try {
            String s1;
            ArrayList<String> arraylist = new ArrayList<String>();
            BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(GuiMainMenu.class.getResourceAsStream("/title/splashes.txt"), Charset.forName("UTF-8")));
            String s = "";
            while ((s1 = bufferedreader.readLine()) != null) {
                if ((s1 = s1.trim()).length() <= 0) continue;
                arraylist.add(s1);
            }
            this.splashText = (String)arraylist.get(rand.nextInt(arraylist.size()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void keyTyped(char c, int i) {
    }

    @Override
    public void initGui() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        if (calendar.get(2) + 1 == 1 && calendar.get(5) == 19) {
            this.splashText = "Happy birthday, jonkadelic!";
        } else if (calendar.get(2) + 1 == 4 && calendar.get(5) == 29) {
            this.splashText = "Happy birthday, MaggAndGeez!";
        } else if (calendar.get(2) + 1 == 5 && calendar.get(5) == 17) {
            this.splashText = "Happy birthday, Minecraft!";
        } else if (calendar.get(2) + 1 == 12 && calendar.get(5) == 24) {
            this.splashText = "Merry X-mas!";
        } else if (calendar.get(2) + 1 == 1 && calendar.get(5) == 1) {
            this.splashText = "Happy New Year!";
        }
        StringTranslate stringtranslate = StringTranslate.getInstance();
        int i = this.height / 4 + 48;
        this.controlList.add(new GuiButton(1, this.width / 2 - 100, i, stringtranslate.translateKey("menu.singleplayer")));
        this.multiplayerButton = new GuiButton(2, this.width / 2 - 100, i + 24, stringtranslate.translateKey("menu.multiplayer"));
        this.controlList.add(this.multiplayerButton);
        this.controlList.add(new GuiButton(3, this.width / 2 - 100, i + 48, new Random().nextInt(1000) == 0 ? "Twin Peaks" : stringtranslate.translateKey("menu.mods")));
        if (this.mc.hideQuitButton) {
            this.controlList.add(new GuiButton(0, this.width / 2 - 100, i + 72, stringtranslate.translateKey("menu.options")));
        } else {
            this.controlList.add(new GuiButton(0, this.width / 2 - 100, i + 72 + 12, 98, 20, stringtranslate.translateKey("menu.options")));
            this.controlList.add(new GuiButton(4, this.width / 2 + 2, i + 72 + 12, 98, 20, stringtranslate.translateKey("menu.quit")));
        }
        this.controlList.add(new GuiClickableLabel(5, 0, this.height - 36, "Discord", 5793266));
        this.controlList.add(new GuiClickableLabel(6, 0, this.height - 24, "Minecraft Forum", 0xE0E0E0));
        this.controlList.add(new GuiClickableLabel(7, 0, this.height - 12, "YouTube", 0xFF0000));
        if (this.mc.session == null) {
            this.multiplayerButton.enabled = false;
        }
        Object a = null;
        if (currentBg == -1) {
            currentBg = this.mc.renderEngine.getTexture("/bg/bg" + rand.nextInt(30) + ".png");
        }
    }

    @Override
    protected void actionPerformed(GuiButton guibutton) {
        Desktop desktop;
        if (guibutton.id == 0) {
            this.mc.displayGuiScreen(new GuiOptions(this, this.mc.gameSettings));
        }
        if (guibutton.id == 1) {
            this.mc.displayGuiScreen(new GuiSelectWorld(this));
        }
        if (guibutton.id == 2) {
            this.mc.displayGuiScreen(new GuiSelectServer(this));
        }
        if (guibutton.id == 3) {
            this.mc.displayGuiScreen(new GuiTexturePacks(this));
        }
        if (guibutton.id == 4) {
            this.mc.shutdown();
        }
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            if (guibutton.id == 5) {
                try {
                    desktop.browse(URI.create("https://discord.com/invite/jvwD8BKq5e"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (guibutton.id == 6) {
                try {
                    desktop.browse(URI.create("https://www.minecraftforum.net/forums/mapping-and-modding-java-edition/minecraft-mods/3106066-better-than-adventure-for-beta-1-7-3-timely"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (guibutton.id == 7) {
                try {
                    desktop.browse(URI.create("https://www.youtube.com/channel/UC_GT4t8Io87-UTzaGNnsuMg"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void drawBackground(int i) {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        Tessellator tessellator = Tessellator.instance;
        float imageWidth = 1024.0f;
        float imageHeight = 512.0f;
        float imageAspectRatio = imageWidth / imageHeight;
        float screenAspectRatio = (float)this.width / (float)this.height;
        float finalAspectRatio = (float)this.width / imageWidth / ((float)this.height / imageHeight);
        GL11.glBindTexture((int)3553, (int)currentBg);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_F(0.6f, 0.6f, 0.6f, 1.0f);
        if (screenAspectRatio < imageAspectRatio) {
            tessellator.addVertexWithUV(0.0, this.height, 0.0, 0.5f - finalAspectRatio / 2.0f, 1.0);
            tessellator.addVertexWithUV(this.width, this.height, 0.0, 0.5f + finalAspectRatio / 2.0f, 1.0);
            tessellator.addVertexWithUV(this.width, 0.0, 0.0, 0.5f + finalAspectRatio / 2.0f, 0.0);
            tessellator.addVertexWithUV(0.0, 0.0, 0.0, 0.5f - finalAspectRatio / 2.0f, 0.0);
        } else {
            tessellator.addVertexWithUV(0.0, this.height, 0.0, 0.0, 0.5f + 0.5f / finalAspectRatio);
            tessellator.addVertexWithUV(this.width, this.height, 0.0, 1.0, 0.5f + 0.5f / finalAspectRatio);
            tessellator.addVertexWithUV(this.width, 0.0, 0.0, 1.0, 0.5f - 0.5f / finalAspectRatio);
            tessellator.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 0.5f - 0.5f / finalAspectRatio);
        }
        tessellator.draw();
        if (drawNextBg) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glBindTexture((int)3553, (int)nextBg);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            tessellator.startDrawingQuads();
            tessellator.setColorRGBA_F(0.6f, 0.6f, 0.6f, 1.0f - currentBackgroundAlpha);
            if (screenAspectRatio < imageAspectRatio) {
                tessellator.addVertexWithUV(0.0, this.height, 0.0, 0.5f - finalAspectRatio / 2.0f, 1.0);
                tessellator.addVertexWithUV(this.width, this.height, 0.0, 0.5f + finalAspectRatio / 2.0f, 1.0);
                tessellator.addVertexWithUV(this.width, 0.0, 0.0, 0.5f + finalAspectRatio / 2.0f, 0.0);
                tessellator.addVertexWithUV(0.0, 0.0, 0.0, 0.5f - finalAspectRatio / 2.0f, 0.0);
            } else {
                tessellator.addVertexWithUV(0.0, this.height, 0.0, 0.0, 0.5f + 0.5f / finalAspectRatio);
                tessellator.addVertexWithUV(this.width, this.height, 0.0, 1.0, 0.5f + 0.5f / finalAspectRatio);
                tessellator.addVertexWithUV(this.width, 0.0, 0.0, 1.0, 0.5f - 0.5f / finalAspectRatio);
                tessellator.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 0.5f - 0.5f / finalAspectRatio);
            }
            tessellator.draw();
        }
        GL11.glDisable((int)3042);
    }

    @Override
    public void updateScreen() {
        if (this.logoEffects != null) {
            for (int var1 = 0; var1 < this.logoEffects.length; ++var1) {
                for (int var2 = 0; var2 < this.logoEffects[var1].length; ++var2) {
                    this.logoEffects[var1][var2].updateLogoEffects();
                }
            }
        }
    }

    @Override
    public void mouseClicked(int x, int y, int button) {
        super.mouseClicked(x, y, button);
        int c = 274;
        int k = this.width / 2 - c / 2;
        int byte0 = 30;
        if (x >= k + 0 && x <= k + 310 && y >= byte0 && y <= byte0 + 64) {
            if (this.logoClickCounter >= 0) {
                boolean bl = this.shouldDrawOldLogo = !this.shouldDrawOldLogo;
                if (this.shouldDrawOldLogo) {
                    this.logoEffects = null;
                }
                this.logoClickCounter = 0;
            } else {
                ++this.logoClickCounter;
            }
        }
    }

    @Override
    public void drawScreen(int x, int y, float renderPartialTicks) {
        this.drawDefaultBackground();
        Tessellator tessellator = Tessellator.instance;
        int c = 274;
        int k = this.width / 2 - c / 2;
        int byte0 = 30;
        if (!this.shouldDrawOldLogo) {
            GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/title/mclogo.png"));
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawTexturedModalRect(k + 0, byte0 + 0, 0, 0, 155, 64);
            this.drawTexturedModalRect(k + 155, byte0 + 0, 0, 64, 155, 64);
        } else {
            this.drawLogo(renderPartialTicks);
        }
        tessellator.setColorOpaque_I(0xFFFFFF);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.width / 2 + 140), (float)80.0f, (float)0.0f);
        GL11.glRotatef((float)-20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f1 = 1.8f - MathHelper.abs(MathHelper.sin((float)(System.currentTimeMillis() % 1000L) / 1000.0f * 3.141593f * 2.0f) * 0.1f);
        f1 = f1 * 100.0f / (float)(this.fontRenderer.getStringWidth(this.splashText) + 32);
        GL11.glScalef((float)f1, (float)f1, (float)f1);
        this.drawCenteredString(this.fontRenderer, this.splashText, 0, -8, 0xFFFF00);
        GL11.glPopMatrix();
        this.drawString(this.fontRenderer, "Better than Adventure! " + "1.7.6.2", 2, 2, 0xFFFFFF);
        String s = "Copyright Mojang AB. Do not distribute!";
        this.drawString(this.fontRenderer, s, this.width - this.fontRenderer.getStringWidth(s) - 2, this.height - 10, 0xFFFFFF);
        super.drawScreen(x, y, renderPartialTicks);
        backgroundCounter += 1.0f;
        if (currentBg == -1 || nextBg == -1) {
            currentBg = this.mc.renderEngine.getTexture("/bg/bg" + rand.nextInt(30) + ".png");
            while (nextBg == -1 || nextBg == currentBg) {
                int r = rand.nextInt(30);
                nextBg = this.mc.renderEngine.getTexture("/bg/bg" + r + ".png");
            }
        }
        if (backgroundCounter >= 20000.0f) {
            currentBackgroundAlpha = 1.0f;
            backgroundCounter = 0.0f;
            drawNextBg = false;
            currentBg = nextBg;
            while (nextBg == -1 || nextBg == currentBg) {
                nextBg = this.mc.renderEngine.getTexture("/bg/bg" + rand.nextInt(30) + ".png");
            }
        } else if (backgroundCounter >= 16000.0f) {
            currentBackgroundAlpha = (float)(Math.cos((double)((backgroundCounter - 16000.0f) / 4000.0f) * Math.PI) + 1.0) / 2.0f;
            drawNextBg = true;
        }
        if (this.mc.downloadResourcesThread.downloading) {
            double b = Math.sin((double)System.currentTimeMillis() / 1000.0 * 4.0);
            b = b * 0.2 + 0.8;
            int ib = (int)Math.round(b * 255.0);
            int color = -16777216 + (ib << 16) + (ib << 8) + ib;
            this.mc.fontRenderer.drawCenteredString("Downloading Resources: " + this.mc.downloadResourcesThread.downloadProgress + " / " + this.mc.downloadResourcesThread.toDownload, this.width / 2, 16, color);
        }
    }

    private void drawLogo(float var1) {
        int var3;
        if (this.logoEffects == null) {
            this.logoEffects = new LogoEffectRandomizer[logoBlockLayers[0].length()][logoBlockLayers.length];
            for (int var2 = 0; var2 < this.logoEffects.length; ++var2) {
                for (var3 = 0; var3 < this.logoEffects[var2].length; ++var3) {
                    this.logoEffects[var2][var3] = new LogoEffectRandomizer(this, var2, var3);
                }
            }
        }
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        var3 = 120 * this.mc.resolution.scale;
        GLU.gluPerspective((float)70.0f, (float)((float)this.mc.resolution.width / (float)var3), (float)0.05f, (float)100.0f);
        GL11.glViewport((int)0, (int)(this.mc.resolution.height - var3), (int)this.mc.resolution.width, (int)var3);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glDisable((int)2884);
        GL11.glCullFace((int)1029);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        for (int var4 = 0; var4 < 3; ++var4) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.4f, (float)0.6f, (float)-12.0f);
            if (var4 == 0) {
                GL11.glClear((int)256);
                GL11.glTranslatef((float)0.0f, (float)-0.4f, (float)0.0f);
                GL11.glScalef((float)0.98f, (float)1.0f, (float)1.0f);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
            }
            if (var4 == 1) {
                GL11.glDisable((int)3042);
                GL11.glClear((int)256);
            }
            if (var4 == 2) {
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)768, (int)1);
            }
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
            GL11.glRotatef((float)15.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)0.89f, (float)1.0f, (float)0.4f);
            GL11.glTranslatef((float)((float)(-logoBlockLayers[0].length()) * 0.5f), (float)((float)(-logoBlockLayers.length) * 0.5f), (float)0.0f);
            GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/terrain.png"));
            if (var4 == 0) {
                GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/title/black.png"));
            }
            RenderBlocks var5 = new RenderBlocks();
            for (int var6 = 0; var6 < logoBlockLayers.length; ++var6) {
                for (int var7 = 0; var7 < logoBlockLayers[var6].length(); ++var7) {
                    char var8 = logoBlockLayers[var6].charAt(var7);
                    if (var8 == ' ') continue;
                    GL11.glPushMatrix();
                    LogoEffectRandomizer var9 = this.logoEffects[var7][var6];
                    float var10 = (float)(var9.prevHeight + (var9.height - var9.prevHeight) * (double)var1);
                    float var11 = 1.0f;
                    float var12 = 1.0f;
                    float var13 = 0.0f;
                    if (var4 == 0) {
                        var11 = var10 * 0.04f + 1.0f;
                        var12 = 1.0f / var11;
                        var10 = 0.0f;
                    }
                    GL11.glTranslatef((float)var7, (float)var6, (float)var10);
                    GL11.glScalef((float)var11, (float)var11, (float)var11);
                    GL11.glRotatef((float)var13, (float)0.0f, (float)1.0f, (float)0.0f);
                    var5.renderBlockAsItem(Block.stone, var12);
                    GL11.glPopMatrix();
                }
            }
            GL11.glPopMatrix();
        }
        GL11.glDisable((int)3042);
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glViewport((int)0, (int)0, (int)this.mc.resolution.width, (int)this.mc.resolution.height);
        GL11.glEnable((int)2884);
    }

    static Random getRandom() {
        return rand;
    }

    public static void loadLogo() {
        try {
            InputStream inputStream = GuiMainMenu.class.getResourceAsStream("/title/retrologo.png");
            BufferedImage image = ImageIO.read(inputStream);
            inputStream.close();
            logoBlockLayers = new String[image.getHeight()];
            for (int i = 0; i < image.getHeight(); ++i) {
                StringBuilder builder = new StringBuilder();
                for (int j = 0; j < image.getWidth(); ++j) {
                    int rgb = image.getRGB(j, i);
                    if ((rgb >> 16 & 0xFF) > 128) {
                        builder.append('*');
                        continue;
                    }
                    builder.append(' ');
                }
                GuiMainMenu.logoBlockLayers[i] = builder.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        GuiMainMenu.loadLogo();
    }
}

