/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import net.minecraft.src.GuiSelectServer;
import net.minecraft.src.GuiSlot;
import net.minecraft.src.SavedServer;
import net.minecraft.src.Tessellator;

class GuiServerSlot
extends GuiSlot {
    final GuiSelectServer parentServerGui;

    public GuiServerSlot(GuiSelectServer guiselectserver) {
        super(guiselectserver.mc, guiselectserver.width, guiselectserver.height, 32, guiselectserver.height - 64, 36);
        this.parentServerGui = guiselectserver;
    }

    @Override
    protected int getSize() {
        return GuiSelectServer.getSize((GuiSelectServer)this.parentServerGui).servers.size();
    }

    @Override
    protected void elementClicked(int i, boolean flag) {
        boolean flag1;
        GuiSelectServer.onElementSelected(this.parentServerGui, i);
        GuiSelectServer.getConnectButton((GuiSelectServer)this.parentServerGui).enabled = flag1 = GuiSelectServer.getSelectedServer(this.parentServerGui) >= 0 && GuiSelectServer.getSelectedServer(this.parentServerGui) < this.getSize();
        GuiSelectServer.getDeleteButton((GuiSelectServer)this.parentServerGui).enabled = flag1;
        if (flag && flag1) {
            this.parentServerGui.selectServer(i);
        }
    }

    @Override
    protected boolean isSelected(int i) {
        return i == GuiSelectServer.getSelectedServer(this.parentServerGui);
    }

    @Override
    protected int getContentHeight() {
        return GuiSelectServer.getSize((GuiSelectServer)this.parentServerGui).servers.size() * 36;
    }

    @Override
    protected void drawBackground() {
        this.parentServerGui.drawDefaultBackground();
    }

    @Override
    protected void drawSlot(int i, int j, int k, int l, Tessellator tessellator) {
        SavedServer server = GuiSelectServer.getSize((GuiSelectServer)this.parentServerGui).servers.get(i);
        String line1 = server.nickname;
        String line2 = server.address;
        String line3 = "Last played: " + server.lastPlayed.format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT));
        this.parentServerGui.drawString(this.parentServerGui.fontRenderer, line1, j + 2, k + 1, 0xFFFFFF);
        this.parentServerGui.drawString(this.parentServerGui.fontRenderer, line2, j + 2, k + 12, 0x808080);
        this.parentServerGui.drawString(this.parentServerGui.fontRenderer, line3, j + 2, k + 12 + 10, 0x808080);
    }
}

