/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.ChatAllowedCharacters;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.Gui;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.helper.ITextField;
import net.minecraft.src.helper.TextFieldInputHandler;

public class GuiTextField
extends Gui
implements ITextField {
    private final FontRenderer fontRenderer;
    public int xPosition;
    public int yPosition;
    public final int width;
    public final int height;
    private String text;
    private int maxStringLength;
    private int cursorCounter;
    public boolean isFocused = false;
    public boolean isEnabled = true;
    private GuiScreen parentGuiScreen;
    private TextChangeListener textChangeListener;

    public GuiTextField(GuiScreen guiscreen, FontRenderer fontrenderer, int i, int j, int k, int l, String s) {
        this.parentGuiScreen = guiscreen;
        this.fontRenderer = fontrenderer;
        this.xPosition = i;
        this.yPosition = j;
        this.width = k;
        this.height = l;
        this.setText(s);
    }

    @Override
    public void setText(String s) {
        this.text = s;
        if (this.textChangeListener != null) {
            this.textChangeListener.textChanged(this);
        }
    }

    @Override
    public String getText() {
        return this.text;
    }

    public void updateCursorCounter() {
        ++this.cursorCounter;
    }

    public void textboxKeyTyped(char c, int key) {
        if (!this.isEnabled || !this.isFocused) {
            return;
        }
        if (key == 15) {
            this.parentGuiScreen.selectNextField();
        }
        if (TextFieldInputHandler.handleKeyTyped(this, key, c) && this.textChangeListener != null) {
            this.textChangeListener.textChanged(this);
        }
    }

    public void mouseClicked(int i, int j, int k) {
        boolean flag = this.isEnabled && i >= this.xPosition && i < this.xPosition + this.width && j >= this.yPosition && j < this.yPosition + this.height;
        this.setFocused(flag);
        if (flag && k == 1) {
            this.setText("");
        }
    }

    public void setFocused(boolean flag) {
        if (flag && !this.isFocused) {
            this.cursorCounter = 0;
        }
        this.isFocused = flag;
    }

    public void drawTextBox() {
        this.drawRect(this.xPosition - 1, this.yPosition - 1, this.xPosition + this.width + 1, this.yPosition + this.height + 1, -6250336);
        this.drawRect(this.xPosition, this.yPosition, this.xPosition + this.width, this.yPosition + this.height, -16777216);
        if (this.isEnabled) {
            boolean flag = this.isFocused && this.cursorCounter / 6 % 2 == 0;
            this.drawString(this.fontRenderer, this.text + (flag ? "_" : ""), this.xPosition + 4, this.yPosition + (this.height - 8) / 2, 0xE0E0E0);
        } else {
            this.drawString(this.fontRenderer, this.text, this.xPosition + 4, this.yPosition + (this.height - 8) / 2, 0x707070);
        }
    }

    public void setMaxStringLength(int i) {
        this.maxStringLength = i;
    }

    @Override
    public boolean isCharacterAllowed(char c) {
        return ChatAllowedCharacters.allowedCharacters.indexOf(c) >= 0;
    }

    @Override
    public int maxLength() {
        return this.maxStringLength == 0 ? 1000 : this.maxStringLength;
    }

    public void setTextChangeListener(TextChangeListener textChangeListener) {
        this.textChangeListener = textChangeListener;
    }

    public static interface TextChangeListener {
        public void textChanged(GuiTextField var1);
    }
}

