/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class ItemDoor
extends Item {
    private Material doorMaterial;

    public ItemDoor(int i, Material material) {
        super(i);
        this.doorMaterial = material;
        this.maxStackSize = 64;
    }

    @Override
    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int x, int y, int z, int l, double heightPlaced) {
        Block doorBlockTop;
        Block doorBlockBottom;
        if (l != 1) {
            return false;
        }
        ++y;
        if (this.doorMaterial == Material.wood) {
            doorBlockBottom = Block.doorPlanksOakBottom;
            doorBlockTop = Block.doorPlanksOakTop;
        } else {
            doorBlockBottom = Block.doorIronBottom;
            doorBlockTop = Block.doorIronTop;
        }
        if (!doorBlockBottom.canPlaceBlockAt(world, x, y, z)) {
            return false;
        }
        int direction = entityplayer.getHorizontalPlacementDirection(null).rotate(1).getIndex();
        int xOffset = 0;
        int zOffset = 0;
        if (direction == 0) {
            zOffset = 1;
        }
        if (direction == 1) {
            xOffset = -1;
        }
        if (direction == 2) {
            zOffset = -1;
        }
        if (direction == 3) {
            xOffset = 1;
        }
        int isSolidBlockLeft = (world.isBlockNormalCube(x - xOffset, y, z - zOffset) ? 1 : 0) + (world.isBlockNormalCube(x - xOffset, y + 1, z - zOffset) ? 1 : 0);
        int isSolidBlockRight = (world.isBlockNormalCube(x + xOffset, y, z + zOffset) ? 1 : 0) + (world.isBlockNormalCube(x + xOffset, y + 1, z + zOffset) ? 1 : 0);
        boolean isDoorLeft = world.getBlockId(x - xOffset, y, z - zOffset) == doorBlockBottom.blockID || world.getBlockId(x - xOffset, y + 1, z - zOffset) == doorBlockTop.blockID;
        boolean isDoorRight = world.getBlockId(x + xOffset, y, z + zOffset) == doorBlockBottom.blockID || world.getBlockId(x + xOffset, y + 1, z + zOffset) == doorBlockTop.blockID;
        boolean isMirrored = false;
        if (isDoorLeft && !isDoorRight) {
            isMirrored = true;
        } else if (isSolidBlockRight > isSolidBlockLeft) {
            isMirrored = true;
        }
        if (isMirrored) {
            direction = direction - 1 & 3;
            direction += 4;
            direction |= 8;
        }
        world.editingBlocks = true;
        world.setBlockAndMetadataWithNotify(x, y, z, doorBlockBottom.blockID, direction);
        world.setBlockAndMetadataWithNotify(x, y + 1, z, doorBlockTop.blockID, direction);
        world.editingBlocks = false;
        world.notifyBlocksOfNeighborChange(x, y, z, doorBlockBottom.blockID);
        world.notifyBlocksOfNeighborChange(x, y + 1, z, doorBlockTop.blockID);
        world.playSoundEffect((float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, doorBlockBottom.stepSound.func_1145_d(), (doorBlockBottom.stepSound.getVolume() + 1.0f) / 2.0f, doorBlockBottom.stepSound.getPitch() * 0.8f);
        itemstack.consumeItem(entityplayer);
        return true;
    }
}

