/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.shared.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.BlockCactus;
import net.minecraft.src.BlockCrops;
import net.minecraft.src.BlockSaplingBase;
import net.minecraft.src.BlockSugarcane;
import net.minecraft.src.BlockWool;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntitySheep;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.World;
import net.minecraft.src.WorldType;

public class ItemDye
extends Item {
    public static final String[] dyeColors = new String[]{"black", "red", "green", "brown", "blue", "purple", "cyan", "silver", "gray", "pink", "lime", "yellow", "lightblue", "magenta", "orange", "white"};
    public static final int[] field_31002_bk = new int[]{0x1E1B1B, 11743532, 3887386, 5320730, 2437522, 8073150, 2651799, 2651799, 0x434343, 14188952, 4312372, 14602026, 6719955, 12801229, 15435844, 0xF0F0F0};

    public ItemDye(int i) {
        super(i);
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
    }

    @Override
    public int getIconFromDamage(int i) {
        int j = i;
        return this.iconIndex + j % 8 * Minecraft.TEXTURE_ATLAS_WIDTH_TILES + j / 8;
    }

    @Override
    public String getItemNameIS(ItemStack itemstack) {
        return super.getItemName() + "." + dyeColors[itemstack.getMetadata()];
    }

    @Override
    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int l, double heightPlaced) {
        if (itemstack.getMetadata() == 15) {
            int i1 = world.getBlockId(i, j, k);
            if (Block.blocksList[i1] instanceof BlockSaplingBase) {
                if (!world.isMultiplayerAndNotHost) {
                    ((BlockSaplingBase)Block.blocksList[i1]).growTree(world, i, j, k, world.rand);
                    if (entityplayer.getGamemode().consumeBlocks) {
                        --itemstack.stackSize;
                    }
                }
                return true;
            }
            if (Block.blocksList[i1] instanceof BlockSugarcane) {
                if (!world.isMultiplayerAndNotHost) {
                    ((BlockSugarcane)Block.blocksList[i1]).growReedOnTop(world, i, j, k);
                    if (entityplayer.getGamemode().consumeBlocks) {
                        --itemstack.stackSize;
                    }
                }
                return true;
            }
            if (Block.blocksList[i1] instanceof BlockCactus) {
                if (!world.isMultiplayerAndNotHost) {
                    ((BlockCactus)Block.blocksList[i1]).growCactusOnTop(world, i, j, k);
                    if (entityplayer.getGamemode().consumeBlocks) {
                        --itemstack.stackSize;
                    }
                }
                return true;
            }
            if (i1 == Block.dirt.blockID) {
                if (!world.isMultiplayerAndNotHost && Block.lightOpacity[world.getBlockId(i, j + 1, k)] <= 2) {
                    int grass = Block.grass.blockID;
                    if (world.worldInfo.getWorldType(0) == WorldType.overworldRetro.id) {
                        grass = Block.grassRetro.blockID;
                    }
                    world.setBlockWithNotify(i, j, k, grass);
                    if (entityplayer.getGamemode().consumeBlocks) {
                        --itemstack.stackSize;
                    }
                }
                return true;
            }
            if (i1 == Block.cropsWheat.blockID) {
                if (!world.isMultiplayerAndNotHost) {
                    ((BlockCrops)Block.cropsWheat).fertilize(world, i, j, k);
                    if (entityplayer.getGamemode().consumeBlocks) {
                        --itemstack.stackSize;
                    }
                }
                return true;
            }
            if (i1 == Block.mossStone.blockID || i1 == Block.mossLimestone.blockID || i1 == Block.mossGranite.blockID || i1 == Block.mossBasalt.blockID) {
                if (!world.isMultiplayerAndNotHost) {
                    if (entityplayer.getGamemode().consumeBlocks) {
                        --itemstack.stackSize;
                    }
                    for (int j1 = 0; j1 < 32; ++j1) {
                        int k1 = i;
                        int l1 = j;
                        int i2 = k;
                        for (int j2 = 0; j2 < j1 / 16; ++j2) {
                            k1 += itemRand.nextInt(3) - 1;
                            l1 += (itemRand.nextInt(3) - 1) * itemRand.nextInt(3) / 2;
                            i2 += itemRand.nextInt(3) - 1;
                        }
                        if (Block.isBuried(world, k1, l1, i2) || world.getBlockLightValue(k1, l1 + 1, i2) > 5 || world.getBlockLightValue(k1, l1 - 1, i2) > 5 || world.getBlockLightValue(k1 + 1, l1, i2) > 5 || world.getBlockLightValue(k1 - 1, l1, i2) > 5 || world.getBlockLightValue(k1, l1, i2 - 1) > 5 || world.getBlockLightValue(k1, l1, i2 + 1) > 5) continue;
                        if (world.getBlockId(k1, l1, i2) == Block.stone.blockID) {
                            world.setBlockWithNotify(k1, l1, i2, Block.mossStone.blockID);
                            continue;
                        }
                        if (world.getBlockId(k1, l1, i2) == Block.limestone.blockID) {
                            world.setBlockWithNotify(k1, l1, i2, Block.mossLimestone.blockID);
                            continue;
                        }
                        if (world.getBlockId(k1, l1, i2) == Block.granite.blockID) {
                            world.setBlockWithNotify(k1, l1, i2, Block.mossGranite.blockID);
                            continue;
                        }
                        if (world.getBlockId(k1, l1, i2) == Block.basalt.blockID) {
                            world.setBlockWithNotify(k1, l1, i2, Block.mossBasalt.blockID);
                            continue;
                        }
                        if (world.getBlockId(k1, l1, i2) == Block.cobbleStone.blockID) {
                            world.setBlockWithNotify(k1, l1, i2, Block.cobbleStoneMossy.blockID);
                            continue;
                        }
                        if (world.getBlockId(k1, l1, i2) == Block.brickStonePolished.blockID) {
                            world.setBlockWithNotify(k1, l1, i2, Block.brickStonePolishedMossy.blockID);
                            continue;
                        }
                        if (world.getBlockId(k1, l1, i2) != Block.logOak.blockID) continue;
                        world.setBlockWithNotify(k1, l1, i2, Block.logOakMossy.blockID);
                    }
                }
                return true;
            }
            if (Block.blocksList[i1] != null && Block.blocksList[i1].plantable) {
                if (!world.isMultiplayerAndNotHost) {
                    if (entityplayer.getGamemode().consumeBlocks) {
                        --itemstack.stackSize;
                    }
                    block2: for (int j1 = 0; j1 < 128; ++j1) {
                        int k1 = i;
                        int l1 = j + 1;
                        int i2 = k;
                        for (int j2 = 0; j2 < j1 / 16; ++j2) {
                            int id = world.getBlockId(k1 += itemRand.nextInt(3) - 1, (l1 += (itemRand.nextInt(3) - 1) * itemRand.nextInt(3) / 2) - 1, i2 += itemRand.nextInt(3) - 1);
                            if (Block.blocksList[id] == null || !Block.blocksList[id].plantable) continue block2;
                        }
                        if (world.getBlockId(k1, l1, i2) != 0) continue;
                        if (itemRand.nextInt(10) != 0) {
                            if (world.getBlockId(k1, l1 - 1, i2) == Block.dirtScorched.blockID || world.getBlockId(k1, l1 - 1, i2) == Block.dirtScorchedRich.blockID) {
                                world.setBlockWithNotify(k1, l1, i2, Block.spinifex.blockID);
                                continue;
                            }
                            world.setBlockWithNotify(k1, l1, i2, Block.tallgrass.blockID);
                            continue;
                        }
                        if (itemRand.nextInt(3) != 0) {
                            world.setBlockWithNotify(k1, l1, i2, Block.flowerYellow.blockID);
                            continue;
                        }
                        world.setBlockWithNotify(k1, l1, i2, Block.flowerRed.blockID);
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean useItemOnEntity(ItemStack itemstack, EntityLiving entityliving, EntityPlayer entityPlayer) {
        if (entityliving instanceof EntitySheep) {
            EntitySheep entitysheep = (EntitySheep)entityliving;
            int i = BlockWool.func_21034_c(itemstack.getMetadata());
            if (entitysheep.getFleeceColor() != i && itemstack.consumeItem(entityPlayer)) {
                entitysheep.setFleeceColor(i);
                return true;
            }
        }
        return false;
    }
}

