/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.World;
import net.minecraft.src.material.ToolMaterial;

public class ItemToolHoe
extends Item {
    private ToolMaterial toolMaterial;

    public ItemToolHoe(int i, ToolMaterial enumtoolmaterial) {
        super(i);
        this.maxStackSize = 1;
        this.toolMaterial = enumtoolmaterial;
        this.setMaxDamage(enumtoolmaterial.getDurability());
    }

    @Override
    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int l, double heightPlaced) {
        int i1 = world.getBlockId(i, j, k);
        int j1 = world.getBlockId(i, j + 1, k);
        if (l != 0 && j1 == 0 && (i1 == Block.grass.blockID || i1 == Block.dirt.blockID || i1 == Block.pathDirt.blockID || i1 == Block.grassRetro.blockID)) {
            Block block = Block.farmlandDirt;
            world.playSoundEffect((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, block.stepSound.func_1145_d(), (block.stepSound.getVolume() + 1.0f) / 2.0f, block.stepSound.getPitch() * 0.8f);
            if (world.isMultiplayerAndNotHost) {
                return true;
            }
            world.setBlockWithNotify(i, j, k, block.blockID);
            itemstack.damageItem(1, entityplayer);
            return true;
        }
        return false;
    }

    @Override
    public boolean onBlockDestroyed(ItemStack itemstack, int id, int x, int y, int z, EntityLiving entityliving) {
        if (id == Block.tallgrass.blockID) {
            if (this.toolMaterial.isSilkTouch()) {
                entityliving.worldObj.dropItem(x, y, z, new ItemStack(Item.itemsList[id]));
            } else if (entityliving.worldObj.rand.nextInt(6) == 0) {
                entityliving.worldObj.dropItem(x, y, z, new ItemStack(Item.seedsWheat));
            }
            itemstack.damageItem(1, entityliving);
        }
        return super.onBlockDestroyed(itemstack, id, x, y, z, entityliving);
    }

    @Override
    public boolean isFull3D() {
        return true;
    }
}

