/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MapCoord;
import net.minecraft.src.MapDataBase;
import net.minecraft.src.MapInfo;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.World;

public class MapData
extends MapDataBase {
    public int xCenter;
    public int zCenter;
    public byte dimenson;
    public byte scale;
    public byte[] field_28176_f = new byte[16384];
    public int field_28175_g;
    public List field_28174_h = new ArrayList();
    private Map field_28172_j = new HashMap();
    public List field_28173_i = new ArrayList();

    public MapData(String s) {
        super(s);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.dimenson = nbttagcompound.getByte("dimension");
        this.xCenter = nbttagcompound.getInteger("xCenter");
        this.zCenter = nbttagcompound.getInteger("zCenter");
        this.scale = nbttagcompound.getByte("scale");
        if (this.scale < 0) {
            this.scale = 0;
        }
        if (this.scale > 4) {
            this.scale = (byte)4;
        }
        int word0 = nbttagcompound.getShort("width");
        int word1 = nbttagcompound.getShort("height");
        if (word0 == 128 && word1 == 128) {
            this.field_28176_f = nbttagcompound.getByteArray("colors");
        } else {
            byte[] abyte0 = nbttagcompound.getByteArray("colors");
            this.field_28176_f = new byte[16384];
            int i = (128 - word0) / 2;
            int j = (128 - word1) / 2;
            for (int k = 0; k < word1; ++k) {
                int l = k + j;
                if (l < 0 && l >= 128) continue;
                for (int i1 = 0; i1 < word0; ++i1) {
                    int j1 = i1 + i;
                    if (j1 < 0 && j1 >= 128) continue;
                    this.field_28176_f[j1 + l * 128] = abyte0[i1 + k * word0];
                }
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setByte("dimension", this.dimenson);
        nbttagcompound.setInteger("xCenter", this.xCenter);
        nbttagcompound.setInteger("zCenter", this.zCenter);
        nbttagcompound.setByte("scale", this.scale);
        nbttagcompound.setShort("width", (short)128);
        nbttagcompound.setShort("height", (short)128);
        nbttagcompound.setByteArray("colors", this.field_28176_f);
    }

    public void func_28169_a(EntityPlayer entityplayer, ItemStack itemstack) {
        if (!this.field_28172_j.containsKey(entityplayer)) {
            MapInfo mapinfo = new MapInfo(this, entityplayer);
            this.field_28172_j.put(entityplayer, mapinfo);
            this.field_28174_h.add(mapinfo);
        }
        this.field_28173_i.clear();
        for (int i = 0; i < this.field_28174_h.size(); ++i) {
            MapInfo mapinfo1 = (MapInfo)this.field_28174_h.get(i);
            if (mapinfo1.entityplayerObj.isDead || !mapinfo1.entityplayerObj.inventory.func_28018_c(itemstack)) {
                this.field_28172_j.remove(mapinfo1.entityplayerObj);
                this.field_28174_h.remove(mapinfo1);
                continue;
            }
            float f = (float)(mapinfo1.entityplayerObj.posX - (double)this.xCenter) / (float)(1 << this.scale);
            float f1 = (float)(mapinfo1.entityplayerObj.posZ - (double)this.zCenter) / (float)(1 << this.scale);
            int j = 64;
            int k = 64;
            if (f < (float)(-j) || f1 < (float)(-k) || f > (float)j || f1 > (float)k) continue;
            byte byte0 = 0;
            byte byte1 = (byte)((double)(f * 2.0f) + 0.5);
            byte byte2 = (byte)((double)(f1 * 2.0f) + 0.5);
            byte byte3 = (byte)((double)(entityplayer.rotationYaw * 16.0f / 360.0f) + 0.5);
            if (this.dimenson == 1) {
                int l = this.field_28175_g / 10;
                byte3 = (byte)(l * l * 34187121 + l * 121 >> 15 & 0xF);
            }
            if (mapinfo1.entityplayerObj.dimension != this.dimenson) continue;
            this.field_28173_i.add(new MapCoord(this, byte0, byte1, byte2, byte3));
        }
    }

    public byte[] func_28171_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        MapInfo mapinfo = (MapInfo)this.field_28172_j.get(entityplayer);
        if (mapinfo == null) {
            return null;
        }
        byte[] abyte0 = mapinfo.func_28118_a(itemstack);
        return abyte0;
    }

    public void func_28170_a(int i, int j, int k) {
        super.markDirty();
        for (int l = 0; l < this.field_28174_h.size(); ++l) {
            MapInfo mapinfo = (MapInfo)this.field_28174_h.get(l);
            if (mapinfo.field_28119_b[i] < 0 || mapinfo.field_28119_b[i] > j) {
                mapinfo.field_28119_b[i] = j;
            }
            if (mapinfo.field_28124_c[i] >= 0 && mapinfo.field_28124_c[i] >= k) continue;
            mapinfo.field_28124_c[i] = k;
        }
    }

    public void func_28173_a(byte[] abyte0) {
        if (abyte0[0] == 0) {
            int i = abyte0[1] & 0xFF;
            int k = abyte0[2] & 0xFF;
            for (int l = 0; l < abyte0.length - 3; ++l) {
                this.field_28176_f[(l + k) * 128 + i] = abyte0[l + 3];
            }
            this.markDirty();
        } else if (abyte0[0] == 1) {
            this.field_28173_i.clear();
            for (int j = 0; j < (abyte0.length - 1) / 3; ++j) {
                byte byte0 = (byte)(abyte0[j * 3 + 1] % 16);
                byte byte1 = abyte0[j * 3 + 2];
                byte byte2 = abyte0[j * 3 + 3];
                byte byte3 = (byte)(abyte0[j * 3 + 1] / 16);
                this.field_28173_i.add(new MapCoord(this, byte0, byte1, byte2, byte3));
            }
        }
    }
}

