/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.server.MinecraftServer;
import net.minecraft.src.NetLoginHandler;
import net.minecraft.src.NetServerHandler;
import net.minecraft.src.NetworkAcceptThread;

public class NetworkListenThread {
    public static Logger logger = Logger.getLogger("Minecraft");
    private ServerSocket serverSocket;
    private Thread networkAcceptThread;
    public volatile boolean field_973_b = false;
    private int field_977_f = 0;
    private ArrayList pendingConnections = new ArrayList();
    private ArrayList playerList = new ArrayList();
    public MinecraftServer mcServer;

    public NetworkListenThread(MinecraftServer minecraftserver, InetAddress inetaddress, int i) throws IOException {
        this.mcServer = minecraftserver;
        this.serverSocket = new ServerSocket(i, 0, inetaddress);
        this.serverSocket.setPerformancePreferences(0, 2, 1);
        this.field_973_b = true;
        this.networkAcceptThread = new NetworkAcceptThread(this, "Listen thread", minecraftserver);
        this.networkAcceptThread.start();
    }

    public void addPlayer(NetServerHandler netserverhandler) {
        this.playerList.add(netserverhandler);
    }

    private void addPendingConnection(NetLoginHandler netloginhandler) {
        if (netloginhandler == null) {
            throw new IllegalArgumentException("Got null pendingconnection!");
        }
        this.pendingConnections.add(netloginhandler);
    }

    public void handleNetworkListenThread() {
        for (int i = 0; i < this.pendingConnections.size(); ++i) {
            NetLoginHandler netloginhandler = (NetLoginHandler)this.pendingConnections.get(i);
            try {
                netloginhandler.tryLogin();
            }
            catch (Exception exception) {
                netloginhandler.kickUser("Internal server error");
                logger.log(Level.WARNING, "Failed to handle packet: " + exception, exception);
            }
            if (netloginhandler.finishedProcessing) {
                this.pendingConnections.remove(i--);
            }
            netloginhandler.netManager.wakeThreads();
        }
        for (int j = 0; j < this.playerList.size(); ++j) {
            NetServerHandler netserverhandler = (NetServerHandler)this.playerList.get(j);
            try {
                netserverhandler.handlePackets();
            }
            catch (Exception exception1) {
                logger.log(Level.WARNING, "Failed to handle packet: " + exception1, exception1);
                netserverhandler.kickPlayer("Internal server error");
            }
            if (netserverhandler.connectionClosed) {
                this.playerList.remove(j--);
            }
            netserverhandler.netManager.wakeThreads();
        }
    }

    static ServerSocket func_713_a(NetworkListenThread networklistenthread) {
        return networklistenthread.serverSocket;
    }

    static int func_712_b(NetworkListenThread networklistenthread) {
        return networklistenthread.field_977_f++;
    }

    static void func_716_a(NetworkListenThread networklistenthread, NetLoginHandler netloginhandler) {
        networklistenthread.addPendingConnection(netloginhandler);
    }
}

