/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NetHandler;
import net.minecraft.src.Packet;

public class Packet103SetSlot
extends Packet {
    public int windowId;
    public int itemSlot;
    public ItemStack myItemStack;

    public Packet103SetSlot() {
    }

    @Override
    public void processPacket(NetHandler nethandler) {
        nethandler.handleSetSlot(this);
    }

    public Packet103SetSlot(int i, int j, ItemStack itemstack) {
        this.windowId = i;
        this.itemSlot = j;
        this.myItemStack = itemstack != null ? itemstack.copy() : itemstack;
    }

    @Override
    public void readPacketData(DataInputStream datainputstream) throws IOException {
        this.windowId = datainputstream.readByte();
        this.itemSlot = datainputstream.readShort();
        short word0 = datainputstream.readShort();
        if (word0 >= 0) {
            byte byte0 = datainputstream.readByte();
            short word1 = datainputstream.readShort();
            NBTTagCompound tag = Packet103SetSlot.readNBTTagCompound(datainputstream);
            this.myItemStack = new ItemStack(word0, (int)byte0, (int)word1, tag);
        } else {
            this.myItemStack = null;
        }
    }

    @Override
    public void writePacketData(DataOutputStream dataoutputstream) throws IOException {
        dataoutputstream.writeByte(this.windowId);
        dataoutputstream.writeShort(this.itemSlot);
        if (this.myItemStack == null) {
            dataoutputstream.writeShort(-1);
        } else {
            dataoutputstream.writeShort(this.myItemStack.itemID);
            dataoutputstream.writeByte(this.myItemStack.stackSize);
            dataoutputstream.writeShort(this.myItemStack.getMetadata());
            Packet103SetSlot.writeNBTTagCompound(this.myItemStack.tag, dataoutputstream);
        }
    }

    @Override
    public int getPacketSize() {
        return 8;
    }
}

