/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NetHandler;
import net.minecraft.src.Packet;

public class Packet5PlayerInventory
extends Packet {
    public int entityID;
    public int slot;
    public int itemID;
    public int itemDamage;
    public NBTTagCompound itemData;

    public Packet5PlayerInventory() {
    }

    public Packet5PlayerInventory(int entityID, int slot, ItemStack itemstack) {
        this.entityID = entityID;
        this.slot = slot;
        if (itemstack == null) {
            this.itemID = -1;
            this.itemDamage = 0;
            this.itemData = new NBTTagCompound();
        } else {
            this.itemID = itemstack.itemID;
            this.itemDamage = itemstack.getMetadata();
            this.itemData = itemstack.tag;
        }
    }

    @Override
    public void readPacketData(DataInputStream datainputstream) throws IOException {
        this.entityID = datainputstream.readInt();
        this.slot = datainputstream.readShort();
        this.itemID = datainputstream.readShort();
        this.itemDamage = datainputstream.readShort();
        this.itemData = Packet5PlayerInventory.readNBTTagCompound(datainputstream);
    }

    @Override
    public void writePacketData(DataOutputStream dataoutputstream) throws IOException {
        dataoutputstream.writeInt(this.entityID);
        dataoutputstream.writeShort(this.slot);
        dataoutputstream.writeShort(this.itemID);
        dataoutputstream.writeShort(this.itemDamage);
        Packet5PlayerInventory.writeNBTTagCompound(this.itemData, dataoutputstream);
    }

    @Override
    public void processPacket(NetHandler nethandler) {
        nethandler.handlePlayerInventory(this);
    }

    @Override
    public int getPacketSize() {
        return 8;
    }
}

