/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.src.ChunkPosition;
import net.minecraft.src.NetHandler;
import net.minecraft.src.Packet;

public class Packet60Explosion
extends Packet {
    public double explosionX;
    public double explosionY;
    public double explosionZ;
    public float explosionSize;
    public Set<ChunkPosition> destroyedBlockPositions;
    public boolean isCannonball;

    public Packet60Explosion() {
    }

    public Packet60Explosion(double d, double d1, double d2, float f, Set<ChunkPosition> set, boolean isCannonball) {
        this.explosionX = d;
        this.explosionY = d1;
        this.explosionZ = d2;
        this.explosionSize = f;
        this.destroyedBlockPositions = new HashSet<ChunkPosition>(set);
        this.isCannonball = isCannonball;
    }

    @Override
    public void readPacketData(DataInputStream datainputstream) throws IOException {
        this.explosionX = datainputstream.readDouble();
        this.explosionY = datainputstream.readDouble();
        this.explosionZ = datainputstream.readDouble();
        this.explosionSize = datainputstream.readFloat();
        int i = datainputstream.readInt();
        this.destroyedBlockPositions = new HashSet<ChunkPosition>();
        int j = (int)this.explosionX;
        int k = (int)this.explosionY;
        int l = (int)this.explosionZ;
        for (int i1 = 0; i1 < i; ++i1) {
            int j1 = datainputstream.readByte() + j;
            int k1 = datainputstream.readByte() + k;
            int l1 = datainputstream.readByte() + l;
            this.destroyedBlockPositions.add(new ChunkPosition(j1, k1, l1));
        }
        this.isCannonball = datainputstream.readBoolean();
    }

    @Override
    public void writePacketData(DataOutputStream dataoutputstream) throws IOException {
        dataoutputstream.writeDouble(this.explosionX);
        dataoutputstream.writeDouble(this.explosionY);
        dataoutputstream.writeDouble(this.explosionZ);
        dataoutputstream.writeFloat(this.explosionSize);
        dataoutputstream.writeInt(this.destroyedBlockPositions.size());
        int i = (int)this.explosionX;
        int j = (int)this.explosionY;
        int k = (int)this.explosionZ;
        for (ChunkPosition chunkPosition : this.destroyedBlockPositions) {
            dataoutputstream.writeByte(chunkPosition.x - i);
            dataoutputstream.writeByte(chunkPosition.y - j);
            dataoutputstream.writeByte(chunkPosition.z - k);
        }
        dataoutputstream.writeBoolean(this.isCannonball);
    }

    @Override
    public void processPacket(NetHandler nethandler) {
        nethandler.handleExplosion(this);
    }

    @Override
    public int getPacketSize() {
        return 32 + this.destroyedBlockPositions.size() * 3 + 1;
    }
}

