/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.ChunkCoordIntPair;
import net.minecraft.src.EntityPlayerMP;
import net.minecraft.src.Packet;
import net.minecraft.src.Packet50PreChunk;
import net.minecraft.src.Packet51MapChunk;
import net.minecraft.src.Packet52MultiBlockChange;
import net.minecraft.src.Packet53BlockChange;
import net.minecraft.src.PlayerManager;
import net.minecraft.src.TileEntity;
import net.minecraft.src.WorldServer;

class PlayerInstance {
    private List players;
    private int chunkX;
    private int chunkZ;
    private ChunkCoordIntPair currentChunk;
    private short[] blocksToUpdate;
    private int numBlocksToUpdate;
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;
    private int minZ;
    private int maxZ;
    final PlayerManager playerManager;

    public PlayerInstance(PlayerManager playermanager, int i, int j) {
        this.playerManager = playermanager;
        this.players = new ArrayList();
        this.blocksToUpdate = new short[10];
        this.numBlocksToUpdate = 0;
        this.chunkX = i;
        this.chunkZ = j;
        this.currentChunk = new ChunkCoordIntPair(i, j);
        playermanager.getMinecraftServer().chunkProviderServer.prepareChunk(i, j);
    }

    public void addPlayer(EntityPlayerMP entityplayermp) {
        if (this.players.contains(entityplayermp)) {
            throw new IllegalStateException("Failed to add player. " + entityplayermp + " already is in chunk " + this.chunkX + ", " + this.chunkZ);
        }
        entityplayermp.field_420_ah.add(this.currentChunk);
        entityplayermp.playerNetServerHandler.sendPacket(new Packet50PreChunk(this.currentChunk.chunkXPos, this.currentChunk.chunkZPos, true));
        this.players.add(entityplayermp);
        entityplayermp.loadedChunks.add(this.currentChunk);
    }

    public void removePlayer(EntityPlayerMP entityplayermp) {
        if (!this.players.contains(entityplayermp)) {
            return;
        }
        this.players.remove(entityplayermp);
        if (this.players.size() == 0) {
            long l = (long)this.chunkX + Integer.MAX_VALUE | (long)this.chunkZ + Integer.MAX_VALUE << 32;
            PlayerManager.getPlayerInstances(this.playerManager).remove(l);
            if (this.numBlocksToUpdate > 0) {
                PlayerManager.getPlayerInstancesToUpdate(this.playerManager).remove(this);
            }
            this.playerManager.getMinecraftServer().chunkProviderServer.func_35391_d(this.chunkX, this.chunkZ);
        }
        entityplayermp.loadedChunks.remove(this.currentChunk);
        if (entityplayermp.field_420_ah.contains(this.currentChunk)) {
            entityplayermp.playerNetServerHandler.sendPacket(new Packet50PreChunk(this.chunkX, this.chunkZ, false));
        }
    }

    public void markBlockNeedsUpdate(int i, int j, int k) {
        if (this.numBlocksToUpdate == 0) {
            PlayerManager.getPlayerInstancesToUpdate(this.playerManager).add(this);
            this.minX = this.maxX = i;
            this.minY = this.maxY = j;
            this.minZ = this.maxZ = k;
        }
        if (this.minX > i) {
            this.minX = i;
        }
        if (this.maxX < i) {
            this.maxX = i;
        }
        if (this.minY > j) {
            this.minY = j;
        }
        if (this.maxY < j) {
            this.maxY = j;
        }
        if (this.minZ > k) {
            this.minZ = k;
        }
        if (this.maxZ < k) {
            this.maxZ = k;
        }
        if (this.numBlocksToUpdate < 10) {
            short word0 = (short)(i << Minecraft.WORLD_HEIGHT_BITS + 4 | k << Minecraft.WORLD_HEIGHT_BITS | j);
            for (int l = 0; l < this.numBlocksToUpdate; ++l) {
                if (this.blocksToUpdate[l] != word0) continue;
                return;
            }
            this.blocksToUpdate[this.numBlocksToUpdate++] = word0;
        }
    }

    public void sendPacketToPlayersInInstance(Packet packet) {
        for (int i = 0; i < this.players.size(); ++i) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)this.players.get(i);
            if (!entityplayermp.field_420_ah.contains(this.currentChunk)) continue;
            entityplayermp.playerNetServerHandler.sendPacket(packet);
        }
    }

    protected boolean anyFlyingPlayersInInstance() {
        boolean any = false;
        for (int i = 0; i < this.players.size(); ++i) {
            if (!((EntityPlayerMP)this.players.get((int)i)).gamemode.canPlayerFly) continue;
            any = true;
            break;
        }
        return any;
    }

    public void onUpdate() {
        WorldServer worldserver = this.playerManager.getMinecraftServer();
        if (this.numBlocksToUpdate == 0) {
            return;
        }
        if (this.numBlocksToUpdate == 1) {
            int i = this.chunkX * 16 + this.minX;
            int l = this.minY;
            int k1 = this.chunkZ * 16 + this.minZ;
            this.sendPacketToPlayersInInstance(new Packet53BlockChange(i, l, k1, worldserver));
            if (Block.isBlockContainer[worldserver.getBlockId(i, l, k1)]) {
                this.updateTileEntity(worldserver.getBlockTileEntity(i, l, k1));
            }
        } else if (this.numBlocksToUpdate >= 10) {
            this.minY = this.minY / 2 * 2;
            this.maxY = (this.maxY / 2 + 1) * 2;
            int minWorldX = this.minX + this.chunkX * 16;
            int minWorldY = this.minY;
            int minWorldZ = this.minZ + this.chunkZ * 16;
            int width = this.maxX - this.minX + 1;
            int height = this.maxY - this.minY + 2;
            int length = this.maxZ - this.minZ + 1;
            if (this.anyFlyingPlayersInInstance()) {
                minWorldX = this.chunkX * 16;
                minWorldY = 0;
                minWorldZ = this.chunkZ * 16;
                width = 16;
                height = Minecraft.WORLD_HEIGHT_BLOCKS;
                length = 16;
            }
            this.sendPacketToPlayersInInstance(new Packet51MapChunk(minWorldX, minWorldY, minWorldZ, width, height, length, worldserver));
            List list = worldserver.getTileEntityList(minWorldX, minWorldY, minWorldZ, minWorldX + width, minWorldY + height, minWorldZ + length);
            for (int j3 = 0; j3 < list.size(); ++j3) {
                this.updateTileEntity((TileEntity)list.get(j3));
            }
        } else {
            this.sendPacketToPlayersInInstance(new Packet52MultiBlockChange(this.chunkX, this.chunkZ, this.blocksToUpdate, this.numBlocksToUpdate, worldserver));
            for (int k = 0; k < this.numBlocksToUpdate; ++k) {
                int x = this.chunkX * 16 + (this.blocksToUpdate[k] >> 12 & 0xF);
                int y = this.blocksToUpdate[k] & 0xFF;
                int z = this.chunkZ * 16 + (this.blocksToUpdate[k] >> 8 & 0xF);
                if (!Block.isBlockContainer[worldserver.getBlockId(x, y, z)]) continue;
                this.updateTileEntity(worldserver.getBlockTileEntity(x, y, z));
            }
        }
        this.numBlocksToUpdate = 0;
    }

    private void updateTileEntity(TileEntity tileentity) {
        Packet packet;
        if (tileentity != null && (packet = tileentity.getDescriptionPacket()) != null) {
            this.sendPacketToPlayersInInstance(packet);
        }
    }
}

