/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.IRecipe;
import net.minecraft.src.InventoryCrafting;
import net.minecraft.src.Item;
import net.minecraft.src.ItemBlock;
import net.minecraft.src.ItemStack;

public class RecipeLabel
implements IRecipe {
    @Override
    public ItemStack getCraftingResult(InventoryCrafting inventorycrafting) {
        ItemStack labelStack = null;
        ItemStack itemStack = null;
        block0: for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stack = inventorycrafting.getItemStackAt(x, y);
                if (stack == null) continue;
                if (stack.itemID == Item.label.itemID && labelStack == null) {
                    labelStack = stack;
                } else if (itemStack == null && stack.canItemBeRenamed()) {
                    itemStack = stack;
                }
                if (labelStack != null && itemStack != null) break block0;
            }
        }
        if (labelStack != null && itemStack != null) {
            ItemStack outStack = itemStack.copy();
            if (labelStack.tag.getBoolean("overrideName")) {
                outStack.tag.setBoolean("overrideName", true);
                outStack.tag.setString("name", labelStack.tag.getString("name"));
            }
            if (labelStack.tag.getBoolean("overrideColor")) {
                outStack.tag.setBoolean("overrideColor", true);
                outStack.tag.setByte("color", labelStack.tag.getByte("color"));
            }
            return outStack;
        }
        return null;
    }

    @Override
    public ItemStack getRecipeOutput() {
        return new ItemStack(Item.label);
    }

    @Override
    public int getRecipeSize() {
        return 2;
    }

    @Override
    public boolean matches(InventoryCrafting inventorycrafting) {
        int labelCount = 0;
        int itemCount = 0;
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stack = inventorycrafting.getItemStackAt(x, y);
                if (stack == null) continue;
                if (stack.itemID == Item.label.itemID) {
                    ++labelCount;
                    continue;
                }
                if (stack.getItem() instanceof ItemBlock || stack.getMaxStackSize() != 1) continue;
                ++itemCount;
            }
        }
        return labelCount == 1 && itemCount == 1;
    }

    @Override
    public ItemStack[] onCraftResult(InventoryCrafting inventorycrafting) {
        ItemStack[] returnStack = new ItemStack[9];
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stack = inventorycrafting.getItemStackAt(x, y);
                if (stack == null) continue;
                inventorycrafting.setSlotContentsAt(x, y, null);
            }
        }
        return returnStack;
    }
}

