/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.IRecipe;
import net.minecraft.src.InventoryCrafting;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;

public class RecipeRepairableStackable
implements IRecipe {
    public Item inItem;
    public ItemStack materialStack;
    public ItemStack inItemStack;
    int originalDamage;
    int totalStackCount;

    public RecipeRepairableStackable(Item inItem, ItemStack materialStack) {
        this.inItem = inItem;
        this.materialStack = materialStack;
        this.inItemStack = new ItemStack(inItem);
        this.totalStackCount = 0;
    }

    @Override
    public boolean matches(InventoryCrafting inventorycrafting) {
        int materialStackCount = 0;
        int inItemCount = 0;
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stack = inventorycrafting.getItemStackAt(x, y);
                if (stack == null) continue;
                if (stack.itemID == this.materialStack.itemID) {
                    ++materialStackCount;
                    continue;
                }
                if (stack.itemID == this.inItem.itemID && stack.getMetadata() > 0) {
                    ++inItemCount;
                    continue;
                }
                return false;
            }
        }
        if (materialStackCount == 0) {
            return false;
        }
        return inItemCount == 1;
    }

    @Override
    public ItemStack getCraftingResult(InventoryCrafting inventorycrafting) {
        ItemStack inItemStack = null;
        this.totalStackCount = 0;
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stack = inventorycrafting.getItemStackAt(x, y);
                if (stack == null) continue;
                if (stack.itemID == this.materialStack.itemID) {
                    this.totalStackCount += stack.stackSize;
                    continue;
                }
                if (stack.itemID != this.inItem.itemID) continue;
                inItemStack = stack.copy();
                this.originalDamage = inItemStack.getMetadata();
            }
        }
        if (inItemStack.getMetadata() - this.totalStackCount > 0) {
            inItemStack.setMetadata(inItemStack.getMetadata() - this.totalStackCount);
        } else {
            inItemStack.setMetadata(0);
        }
        if (inItemStack.getMetadata() < 0) {
            inItemStack.setMetadata(0);
        }
        return inItemStack;
    }

    @Override
    public ItemStack[] onCraftResult(InventoryCrafting inventorycrafting) {
        int repairCost = this.originalDamage - this.inItemStack.getMetadata();
        ItemStack[] returnStack = new ItemStack[9];
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stack = inventorycrafting.getItemStackAt(x, y);
                if (stack == null) continue;
                if (stack.getItem() == this.inItem) {
                    inventorycrafting.setSlotContentsAt(x, y, null);
                }
                if (stack.getItem() != this.materialStack.getItem()) continue;
                if (repairCost <= 0) {
                    return returnStack;
                }
                ItemStack replacementStack = stack.stackSize - repairCost <= 0 ? null : new ItemStack(stack.getItem(), stack.stackSize - repairCost);
                repairCost -= stack.stackSize;
                inventorycrafting.setSlotContentsAt(x, y, replacementStack);
            }
        }
        return returnStack;
    }

    @Override
    public int getRecipeSize() {
        return 2;
    }

    @Override
    public ItemStack getRecipeOutput() {
        return this.inItemStack;
    }
}

