/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.IInventory;
import net.minecraft.src.InventoryPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.StatList;

public class Slot {
    protected final int slotIndex;
    protected final IInventory inventory;
    public int id;
    public int xDisplayPosition;
    public int yDisplayPosition;
    public boolean discovered = true;

    public Slot(IInventory iinventory, int id, int x, int y) {
        this.inventory = iinventory;
        this.slotIndex = id;
        this.xDisplayPosition = x;
        this.yDisplayPosition = y;
    }

    public ItemStack decrStackSize(int i) {
        return this.inventory.decrStackSize(this.slotIndex, i);
    }

    public int getBackgroundIconIndex() {
        return -1;
    }

    public boolean hasStack() {
        return this.getStack() != null;
    }

    public int getSlotStackLimit() {
        return this.inventory.getInventoryStackLimit();
    }

    public ItemStack getStack() {
        return this.inventory.getStackInSlot(this.slotIndex);
    }

    public boolean isHere(IInventory iinventory, int i) {
        return iinventory == this.inventory && i == this.slotIndex;
    }

    public boolean canPutStackInSlot(ItemStack itemstack) {
        return true;
    }

    public void onPickupFromSlot(ItemStack itemstack) {
        this.onSlotChanged();
    }

    public void onSlotChanged() {
        this.inventory.onInventoryChanged();
    }

    public void putStack(ItemStack itemstack) {
        this.inventory.setInventorySlotContents(this.slotIndex, itemstack);
        this.onSlotChanged();
        if (this.inventory instanceof InventoryPlayer) {
            InventoryPlayer inventoryPlayer = (InventoryPlayer)this.inventory;
            if (itemstack != null) {
                inventoryPlayer.player.addStat(StatList.pickUpItemStats[itemstack.itemID], 1);
            }
        }
    }
}

