/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.AchievementList;
import net.minecraft.src.Block;
import net.minecraft.src.ContainerPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.Item;
import net.minecraft.src.ItemArmor;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Slot;

class SlotArmor
extends Slot {
    final int armorType;
    final ContainerPlayer inventory;

    SlotArmor(ContainerPlayer containerplayer, IInventory iinventory, int i, int j, int k, int l) {
        super(iinventory, i, j, k);
        this.inventory = containerplayer;
        this.armorType = l;
    }

    @Override
    public int getSlotStackLimit() {
        return 1;
    }

    @Override
    public boolean canPutStackInSlot(ItemStack itemstack) {
        if (itemstack.getItem() instanceof ItemArmor) {
            return ((ItemArmor)itemstack.getItem()).armorPiece == this.armorType;
        }
        if (itemstack.getItem().itemID == Block.pumpkinCarvedIdle.blockID) {
            return this.armorType == 0;
        }
        if (itemstack.getItem().itemID == Item.armorQuiverGold.itemID || itemstack.getItem().itemID == Item.armorQuiver.itemID) {
            return this.armorType == 1;
        }
        return false;
    }

    @Override
    public void onSlotChanged() {
        super.onSlotChanged();
        int count = 0;
        for (int i = 0; i < this.inventory.inventorySlots.size(); ++i) {
            ItemStack stack;
            if (!(this.inventory.inventorySlots.get(i) instanceof SlotArmor) || (stack = ((Slot)this.inventory.inventorySlots.get(i)).getStack()) == null || stack.itemID != Item.armorBootsChainmail.itemID && stack.itemID != Item.armorHelmetChainmail.itemID && stack.itemID != Item.armorChestplateChainmail.itemID && stack.itemID != Item.armorLeggingsChainmail.itemID) continue;
            ++count;
        }
        if (count == 4) {
            this.inventory.playerInv.player.triggerAchievement(AchievementList.chainmailGet);
        }
    }

    @Override
    public int getBackgroundIconIndex() {
        return Item.iconCoordToIndex(15, this.armorType);
    }
}

