/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.PositionTextureVertex;
import net.minecraft.src.Tessellator;
import net.minecraft.src.Vec3D;

public class TexturedQuad {
    public PositionTextureVertex[] vertexPositions;
    public int nVertices = 0;
    private boolean invertNormal = false;

    public TexturedQuad(PositionTextureVertex[] apositiontexturevertex) {
        this.vertexPositions = apositiontexturevertex;
        this.nVertices = apositiontexturevertex.length;
    }

    public TexturedQuad(PositionTextureVertex[] apositiontexturevertex, int i, int j, int k, int l) {
        this(apositiontexturevertex);
        float f = 0.0015625f;
        float f1 = 0.003125f;
        apositiontexturevertex[0] = apositiontexturevertex[0].setTexturePosition((float)k / 64.0f - f, (float)j / 32.0f + f1);
        apositiontexturevertex[1] = apositiontexturevertex[1].setTexturePosition((float)i / 64.0f + f, (float)j / 32.0f + f1);
        apositiontexturevertex[2] = apositiontexturevertex[2].setTexturePosition((float)i / 64.0f + f, (float)l / 32.0f - f1);
        apositiontexturevertex[3] = apositiontexturevertex[3].setTexturePosition((float)k / 64.0f - f, (float)l / 32.0f - f1);
    }

    public void flipFace() {
        PositionTextureVertex[] apositiontexturevertex = new PositionTextureVertex[this.vertexPositions.length];
        for (int i = 0; i < this.vertexPositions.length; ++i) {
            apositiontexturevertex[i] = this.vertexPositions[this.vertexPositions.length - i - 1];
        }
        this.vertexPositions = apositiontexturevertex;
    }

    public void draw(Tessellator tessellator, float f) {
        Vec3D vec3d = this.vertexPositions[1].vector3D.subtract(this.vertexPositions[0].vector3D);
        Vec3D vec3d1 = this.vertexPositions[1].vector3D.subtract(this.vertexPositions[2].vector3D);
        Vec3D vec3d2 = vec3d1.crossProduct(vec3d).normalize();
        tessellator.startDrawingQuads();
        if (this.invertNormal) {
            tessellator.setNormal(-((float)vec3d2.xCoord), -((float)vec3d2.yCoord), -((float)vec3d2.zCoord));
        } else {
            tessellator.setNormal((float)vec3d2.xCoord, (float)vec3d2.yCoord, (float)vec3d2.zCoord);
        }
        for (int i = 0; i < 4; ++i) {
            PositionTextureVertex positiontexturevertex = this.vertexPositions[i];
            tessellator.addVertexWithUV((float)positiontexturevertex.vector3D.xCoord * f, (float)positiontexturevertex.vector3D.yCoord * f, (float)positiontexturevertex.vector3D.zCoord * f, positiontexturevertex.texturePositionX, positiontexturevertex.texturePositionY);
        }
        tessellator.draw();
    }
}

