/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Material;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;

public class TileEntityNote
extends TileEntity {
    public byte note = 0;
    public boolean previousRedstoneState = false;

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setByte("note", this.note);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.note = nbttagcompound.getByte("note");
        if (this.note < 0) {
            this.note = 0;
        }
        if (this.note > 24) {
            this.note = (byte)24;
        }
    }

    public void changePitch() {
        this.note = (byte)((this.note + 1) % 25);
        this.onInventoryChanged();
    }

    public void triggerNote(World world, int i, int j, int k) {
        if (world.getBlockMaterial(i, j + 1, k) != Material.air) {
            return;
        }
        Material material = world.getBlockMaterial(i, j - 1, k);
        int byte0 = 0;
        if (material == Material.rock) {
            byte0 = 1;
        }
        if (material == Material.sand) {
            byte0 = 2;
        }
        if (material == Material.glass) {
            byte0 = 3;
        }
        if (material == Material.wood) {
            byte0 = 4;
        }
        world.playNoteAt(i, j, k, byte0, this.note);
    }
}

