/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.ChunkConverter;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.TileEntity;

public class TileEntityRecordPlayer
extends TileEntity {
    public int record;

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.record = nbttagcompound.getInteger("Record");
        byte expanded = nbttagcompound.getByte("Expanded");
        if (expanded == 0 && this.record >= 256) {
            this.record += Block.blocksList.length - 256;
        }
        if (this.record < Block.blocksList.length) {
            short[] id = new short[]{(short)this.record};
            byte[] meta = new byte[]{0};
            ChunkConverter.converters[0].convertBlocksAndMetadata(id, meta);
            this.record = id[0];
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        if (this.record > 0) {
            nbttagcompound.setInteger("Record", this.record);
            nbttagcompound.setByte("Expanded", (byte)1);
        }
    }
}

