/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.RenderEngine;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityMobSpawner;
import net.minecraft.src.TileEntityMobSpawnerRenderer;
import net.minecraft.src.TileEntityPiston;
import net.minecraft.src.TileEntityRendererPiston;
import net.minecraft.src.TileEntitySign;
import net.minecraft.src.TileEntitySignRenderer;
import net.minecraft.src.TileEntitySpecialRenderer;
import net.minecraft.src.World;
import org.lwjgl.opengl.GL11;

public class TileEntityRenderer {
    private Map specialRendererMap = new HashMap();
    public static TileEntityRenderer instance = new TileEntityRenderer();
    private FontRenderer fontRenderer;
    public static double staticPlayerX;
    public static double staticPlayerY;
    public static double staticPlayerZ;
    public RenderEngine renderEngine;
    public World worldObj;
    public EntityLiving entityLivingPlayer;
    public float playerYaw;
    public float playerPitch;
    public double playerX;
    public double playerY;
    public double playerZ;

    private TileEntityRenderer() {
        this.specialRendererMap.put(TileEntitySign.class, new TileEntitySignRenderer());
        this.specialRendererMap.put(TileEntityMobSpawner.class, new TileEntityMobSpawnerRenderer());
        this.specialRendererMap.put(TileEntityPiston.class, new TileEntityRendererPiston());
        for (TileEntitySpecialRenderer tileentityspecialrenderer : this.specialRendererMap.values()) {
            tileentityspecialrenderer.setTileEntityRenderer(this);
        }
    }

    public TileEntitySpecialRenderer getSpecialRendererForClass(Class class1) {
        TileEntitySpecialRenderer tileentityspecialrenderer = (TileEntitySpecialRenderer)this.specialRendererMap.get(class1);
        if (tileentityspecialrenderer == null && class1 != TileEntity.class) {
            tileentityspecialrenderer = this.getSpecialRendererForClass(class1.getSuperclass());
            this.specialRendererMap.put(class1, tileentityspecialrenderer);
        }
        return tileentityspecialrenderer;
    }

    public boolean hasSpecialRenderer(TileEntity tileentity) {
        return this.getSpecialRendererForEntity(tileentity) != null;
    }

    public TileEntitySpecialRenderer getSpecialRendererForEntity(TileEntity tileentity) {
        if (tileentity == null) {
            return null;
        }
        return this.getSpecialRendererForClass(tileentity.getClass());
    }

    public void cacheActiveRenderInfo(World world, RenderEngine renderengine, FontRenderer fontrenderer, EntityLiving entityliving, float f) {
        if (this.worldObj != world) {
            this.func_31072_a(world);
        }
        this.renderEngine = renderengine;
        this.entityLivingPlayer = entityliving;
        this.fontRenderer = fontrenderer;
        this.playerYaw = entityliving.prevRotationYaw + (entityliving.rotationYaw - entityliving.prevRotationYaw) * f;
        this.playerPitch = entityliving.prevRotationPitch + (entityliving.rotationPitch - entityliving.prevRotationPitch) * f;
        this.playerX = entityliving.lastTickPosX + (entityliving.posX - entityliving.lastTickPosX) * (double)f;
        this.playerY = entityliving.lastTickPosY + (entityliving.posY - entityliving.lastTickPosY) * (double)f;
        this.playerZ = entityliving.lastTickPosZ + (entityliving.posZ - entityliving.lastTickPosZ) * (double)f;
    }

    public void renderTileEntity(TileEntity tileentity, float f) {
        if (tileentity.getDistanceFrom(this.playerX, this.playerY, this.playerZ) < 4096.0) {
            float f1 = this.worldObj.getLightBrightness(tileentity.xCoord, tileentity.yCoord, tileentity.zCoord);
            GL11.glColor3f((float)f1, (float)f1, (float)f1);
            this.renderTileEntityAt(tileentity, (double)tileentity.xCoord - staticPlayerX, (double)tileentity.yCoord - staticPlayerY, (double)tileentity.zCoord - staticPlayerZ, f);
        }
    }

    public void renderTileEntityAt(TileEntity tileentity, double d, double d1, double d2, float f) {
        TileEntitySpecialRenderer tileentityspecialrenderer = this.getSpecialRendererForEntity(tileentity);
        if (tileentityspecialrenderer != null) {
            tileentityspecialrenderer.renderTileEntityAt(tileentity, d, d1, d2, f);
        }
    }

    public void func_31072_a(World world) {
        this.worldObj = world;
        for (TileEntitySpecialRenderer tileentityspecialrenderer : this.specialRendererMap.values()) {
            if (tileentityspecialrenderer == null) continue;
            tileentityspecialrenderer.func_31069_a(world);
        }
    }

    public FontRenderer getFontRenderer() {
        return this.fontRenderer;
    }
}

