/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockChest;
import net.minecraft.src.BlockTrommel;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntitySlime;
import net.minecraft.src.IInventory;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.LookupFuelFurnace;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityChest;
import net.minecraft.src.WeightedRandomBag;
import net.minecraft.src.WeightedRandomLootObject;

public class TileEntityTrommel
extends TileEntity
implements IInventory {
    private ItemStack[] itemStacks = new ItemStack[5];
    public int burnTime = 0;
    public int currentItemBurnTime = 0;
    public int itemPopTime = 0;
    private final int maxBurnTime;
    private int nextToSieve = 1;
    private final Random rand = new Random();
    private static final WeightedRandomBag<WeightedRandomLootObject> trommelDropsDirt = new WeightedRandomBag();
    private static final WeightedRandomBag<WeightedRandomLootObject> trommelDropsGravel;
    private static final WeightedRandomBag<WeightedRandomLootObject> trommelDropsClay;
    private static final WeightedRandomBag<WeightedRandomLootObject> trommelDropsSand;
    private static final WeightedRandomBag<WeightedRandomLootObject> trommelDropsRichDirt;
    private static final WeightedRandomBag<WeightedRandomLootObject> trommelDropsSoulSand;

    public TileEntityTrommel() {
        this.maxBurnTime = 50;
    }

    @Override
    public int getSizeInventory() {
        return this.itemStacks.length;
    }

    @Override
    public ItemStack getStackInSlot(int i) {
        return this.itemStacks[i];
    }

    @Override
    public ItemStack decrStackSize(int i, int j) {
        if (this.itemStacks[i] != null) {
            if (this.itemStacks[i].stackSize <= j) {
                ItemStack itemstack = this.itemStacks[i];
                this.itemStacks[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.itemStacks[i].splitStack(j);
            if (this.itemStacks[i].stackSize == 0) {
                this.itemStacks[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    @Override
    public void setInventorySlotContents(int i, ItemStack itemstack) {
        this.itemStacks[i] = itemstack;
        if (itemstack != null && itemstack.stackSize > this.getInventoryStackLimit()) {
            itemstack.stackSize = this.getInventoryStackLimit();
        }
    }

    @Override
    public String getInvName() {
        return "Trommel";
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.getTagList("Items");
        this.itemStacks = new ItemStack[this.getSizeInventory()];
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.tagAt(i);
            byte byte0 = nbttagcompound1.getByte("Slot");
            if (byte0 < 0 || byte0 >= this.itemStacks.length) continue;
            this.itemStacks[byte0] = new ItemStack(nbttagcompound1);
        }
        this.burnTime = nbttagcompound.getShort("BurnTime");
        this.itemPopTime = nbttagcompound.getShort("CookTime");
        this.currentItemBurnTime = this.getItemBurnTime(this.itemStacks[1]);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setShort("BurnTime", (short)this.burnTime);
        nbttagcompound.setShort("CookTime", (short)this.itemPopTime);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.itemStacks.length; ++i) {
            if (this.itemStacks[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.setByte("Slot", (byte)i);
            this.itemStacks[i].writeToNBT(nbttagcompound1);
            nbttaglist.setTag(nbttagcompound1);
        }
        nbttagcompound.setTag("Items", nbttaglist);
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    public float getCookProgressPercent(int i) {
        return (float)this.itemPopTime / (float)this.maxBurnTime * (float)i;
    }

    public int getBurnTimeRemainingScaled(int i) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = this.maxBurnTime;
        }
        return this.burnTime * i / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    @Override
    public void updateEntity() {
        if (this.nextToSieve > 4) {
            this.nextToSieve = 1;
        }
        boolean isBurning = this.burnTime > 0;
        boolean flag1 = false;
        if (isBurning) {
            --this.burnTime;
        }
        if (!this.worldObj.isMultiplayerAndNotHost) {
            if (this.worldObj.getBlockId(this.xCoord, this.yCoord, this.zCoord) == Block.trommelIdle.blockID && this.currentItemBurnTime == 0 && this.itemStacks[0] == null && this.itemStacks[4] != null && this.itemStacks[4].itemID == Block.netherrack.blockID) {
                --this.itemStacks[4].stackSize;
                if (this.itemStacks[4].stackSize == 0) {
                    this.itemStacks[4] = null;
                }
                BlockTrommel.updateTrommelBlockState(true, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
                flag1 = true;
            }
            if (!this.canProduce(this.nextToSieve)) {
                this.nextToSieve = (this.nextToSieve + 1) % 4;
            }
            if (this.burnTime == 0 && this.canProduce(this.nextToSieve)) {
                this.currentItemBurnTime = this.burnTime = this.getItemBurnTime(this.itemStacks[4]);
                if (this.burnTime > 0) {
                    flag1 = true;
                    if (this.itemStacks[4] != null) {
                        --this.itemStacks[4].stackSize;
                        if (this.itemStacks[4].stackSize == 0) {
                            this.itemStacks[4] = null;
                        }
                    }
                }
            }
            if (this.isBurning() && this.canProduce(this.nextToSieve)) {
                ++this.itemPopTime;
                if (this.itemPopTime == this.maxBurnTime) {
                    this.itemPopTime = 0;
                    this.sieveItem(this.nextToSieve);
                    this.nextToSieve = (this.nextToSieve + 1) % 4;
                    flag1 = true;
                }
            } else {
                this.itemPopTime = 0;
            }
            if (isBurning != this.burnTime > 0) {
                flag1 = true;
                BlockTrommel.updateTrommelBlockState(this.burnTime > 0, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
            }
        }
        if (flag1) {
            this.onInventoryChanged();
        }
    }

    private boolean canProduce(int slotIndex) {
        return this.itemStacks[slotIndex] != null && this.canItemBeTrommeled(this.itemStacks[slotIndex]);
    }

    public void sieveItem(int slotIndex) {
        if (!this.canProduce(slotIndex)) {
            return;
        }
        ItemStack itemResult = this.getItemResult(this.itemStacks[slotIndex]);
        --this.itemStacks[slotIndex].stackSize;
        if (this.itemStacks[slotIndex].stackSize <= 0) {
            this.itemStacks[slotIndex] = null;
        }
        if (itemResult != null) {
            int xOffset = 0;
            int zOffset = 0;
            int meta = this.worldObj.getBlockMetadata(this.xCoord, this.yCoord, this.zCoord) & 7;
            if (meta == 2) {
                xOffset = -1;
            } else if (meta == 5) {
                zOffset = -1;
            } else if (meta == 3) {
                xOffset = 1;
            } else if (meta == 4) {
                zOffset = 1;
            }
            int adjacentId = this.worldObj.getBlockId(this.xCoord + xOffset, this.yCoord, this.zCoord + zOffset);
            TileEntityChest chest = null;
            if (Block.blocksList[adjacentId] instanceof BlockChest) {
                chest = (TileEntityChest)this.worldObj.getBlockTileEntity(this.xCoord + xOffset, this.yCoord, this.zCoord + zOffset);
            }
            if (chest != null) {
                ItemStack slot;
                int i;
                for (i = 0; i < chest.getSizeInventory(); ++i) {
                    slot = chest.getStackInSlot(i);
                    if (slot == null || slot.itemID != itemResult.itemID || slot.getMetadata() != itemResult.getMetadata()) continue;
                    while (slot.stackSize + 1 <= slot.getMaxStackSize()) {
                        ++slot.stackSize;
                        chest.setInventorySlotContents(i, slot);
                        if (itemResult.stackSize <= 0) {
                            return;
                        }
                        --itemResult.stackSize;
                    }
                }
                if (itemResult.stackSize <= 0) {
                    return;
                }
                for (i = 0; i < chest.getSizeInventory(); ++i) {
                    slot = chest.getStackInSlot(i);
                    if (slot != null) continue;
                    chest.setInventorySlotContents(i, itemResult);
                    return;
                }
            }
            if (itemResult.stackSize > 0) {
                float f = this.rand.nextFloat() * 0.8f + 0.1f;
                float f1 = this.rand.nextFloat() * 0.8f + 0.1f;
                float f2 = this.rand.nextFloat() * 0.8f + 0.1f;
                EntityItem entityitem = new EntityItem(this.worldObj, (float)this.xCoord + f, (float)this.yCoord + f1, (float)this.zCoord + f2, itemResult);
                float f3 = 0.05f;
                entityitem.motionX = (float)this.rand.nextGaussian() * f3;
                entityitem.motionY = (float)this.rand.nextGaussian() * f3 + 0.2f;
                entityitem.motionZ = (float)this.rand.nextGaussian() * f3;
                this.worldObj.entityJoinedWorld(entityitem);
            }
        }
        if (this.rand.nextInt(4000) == 0) {
            float f = 0.125f;
            float f1 = 0.125f;
            EntitySlime entityslime = new EntitySlime(this.worldObj);
            entityslime.setSlimeSize(1);
            entityslime.setLocationAndAngles((double)this.xCoord + (double)f, (double)this.yCoord + 1.0, (double)this.zCoord + (double)f1, this.rand.nextFloat() * 360.0f, 0.0f);
            float f3 = 0.05f;
            entityslime.motionX = (float)this.rand.nextGaussian() * f3;
            entityslime.motionY = (float)this.rand.nextGaussian() * f3 + 0.2f;
            entityslime.motionZ = (float)this.rand.nextGaussian() * f3;
            this.worldObj.entityJoinedWorld(entityslime);
        }
    }

    private ItemStack getItemResult(ItemStack slotItem) {
        int i = slotItem.getItem().itemID;
        if (i == Block.dirt.blockID || i == Block.dirtScorched.blockID || i == Block.grass.blockID || i == Block.grassRetro.blockID || i == Block.pathDirt.blockID || i == Block.farmlandDirt.blockID) {
            return trommelDropsDirt.getRandom().getItemStack();
        }
        if (i == Block.sand.blockID) {
            return trommelDropsSand.getRandom().getItemStack();
        }
        if (i == Block.gravel.blockID) {
            return trommelDropsGravel.getRandom().getItemStack();
        }
        if (i == Block.blockClay.blockID) {
            return trommelDropsClay.getRandom().getItemStack();
        }
        if (i == Block.dirtScorchedRich.blockID) {
            return trommelDropsRichDirt.getRandom().getItemStack();
        }
        if (i == Block.soulsand.blockID) {
            return trommelDropsSoulSand.getRandom().getItemStack();
        }
        return null;
    }

    private boolean canItemBeTrommeled(ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        int i = itemstack.getItem().itemID;
        if (i == Block.dirt.blockID || i == Block.grass.blockID || i == Block.grassRetro.blockID || i == Block.pathDirt.blockID || i == Block.farmlandDirt.blockID) {
            return true;
        }
        if (i == Block.sand.blockID) {
            return true;
        }
        if (i == Block.dirtScorchedRich.blockID) {
            return true;
        }
        if (i == Block.dirtScorched.blockID) {
            return true;
        }
        if (i == Block.soulsand.blockID) {
            return true;
        }
        return i == Block.gravel.blockID;
    }

    private int getItemBurnTime(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        return LookupFuelFurnace.fuelFurnace().getFuelYield(itemStack.getItem().itemID);
    }

    @Override
    public boolean canInteractWith(EntityPlayer entityplayer) {
        if (this.worldObj.getBlockTileEntity(this.xCoord, this.yCoord, this.zCoord) != this) {
            return false;
        }
        return entityplayer.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    static {
        trommelDropsDirt.addEntry(new WeightedRandomLootObject(new ItemStack(Item.ammoPebble), 1, 3), 50.0);
        trommelDropsDirt.addEntry(new WeightedRandomLootObject(new ItemStack(Item.clay), 1, 5), 20.0);
        trommelDropsDirt.addEntry(new WeightedRandomLootObject(new ItemStack(Item.flint), 1, 3), 10.0);
        trommelDropsDirt.addEntry(new WeightedRandomLootObject(new ItemStack(Item.sulphur)), 2.0);
        trommelDropsDirt.addEntry(new WeightedRandomLootObject(new ItemStack(Item.nuggetIron), 1, 3), 0.5);
        trommelDropsDirt.addEntry(new WeightedRandomLootObject(new ItemStack(Item.olivine)), 0.25);
        trommelDropsDirt.addEntry(new WeightedRandomLootObject(new ItemStack(Item.quartz)), 0.25);
        trommelDropsGravel = new WeightedRandomBag();
        trommelDropsGravel.addEntry(new WeightedRandomLootObject(new ItemStack(Item.flint), 1, 5), 50.0);
        trommelDropsGravel.addEntry(new WeightedRandomLootObject(new ItemStack(Item.olivine), 1, 3), 30.0);
        trommelDropsGravel.addEntry(new WeightedRandomLootObject(new ItemStack(Item.ammoPebble), 1, 6), 25.0);
        trommelDropsGravel.addEntry(new WeightedRandomLootObject(new ItemStack(Item.nuggetIron), 2, 4), 10.0);
        trommelDropsGravel.addEntry(new WeightedRandomLootObject(new ItemStack(Item.dye, 1, 4), 2, 6), 5.0);
        trommelDropsGravel.addEntry(new WeightedRandomLootObject(new ItemStack(Item.sulphur)), 5.0);
        trommelDropsGravel.addEntry(new WeightedRandomLootObject(new ItemStack(Item.quartz)), 0.5);
        trommelDropsClay = new WeightedRandomBag();
        trommelDropsClay.addEntry(new WeightedRandomLootObject(new ItemStack(Item.clay), 4, 8), 30.0);
        trommelDropsClay.addEntry(new WeightedRandomLootObject(new ItemStack(Item.ammoPebble), 1, 3), 20.0);
        trommelDropsClay.addEntry(new WeightedRandomLootObject(new ItemStack(Item.sulphur)), 10.0);
        trommelDropsClay.addEntry(new WeightedRandomLootObject(new ItemStack(Item.nuggetGold), 1, 3), 5.0);
        trommelDropsSand = new WeightedRandomBag();
        trommelDropsSand.addEntry(new WeightedRandomLootObject(new ItemStack(Item.quartz), 1, 3), 50.0);
        trommelDropsSand.addEntry(new WeightedRandomLootObject(new ItemStack(Item.clay), 4, 8), 30.0);
        trommelDropsSand.addEntry(new WeightedRandomLootObject(new ItemStack(Item.ammoPebble), 1, 5), 25.0);
        trommelDropsSand.addEntry(new WeightedRandomLootObject(new ItemStack(Item.bone), 1, 3), 10.0);
        trommelDropsSand.addEntry(new WeightedRandomLootObject(new ItemStack(Item.flint), 1, 3), 10.0);
        trommelDropsSand.addEntry(new WeightedRandomLootObject(new ItemStack(Item.sulphur)), 5.0);
        trommelDropsSand.addEntry(new WeightedRandomLootObject(new ItemStack(Item.nuggetGold), 4, 8), 5.0);
        trommelDropsSand.addEntry(new WeightedRandomLootObject(new ItemStack(Item.olivine)), 5.0);
        trommelDropsRichDirt = new WeightedRandomBag();
        trommelDropsRichDirt.addEntry(new WeightedRandomLootObject(new ItemStack(Item.nuggetGold), 1, 6), 40.0);
        trommelDropsRichDirt.addEntry(new WeightedRandomLootObject(new ItemStack(Item.nuggetIron), 1, 6), 40.0);
        trommelDropsRichDirt.addEntry(new WeightedRandomLootObject(new ItemStack(Item.quartz), 1, 4), 25.0);
        trommelDropsRichDirt.addEntry(new WeightedRandomLootObject(new ItemStack(Item.olivine), 1, 4), 25.0);
        trommelDropsRichDirt.addEntry(new WeightedRandomLootObject(new ItemStack(Item.dye, 1, 4), 2, 8), 20.0);
        trommelDropsRichDirt.addEntry(new WeightedRandomLootObject(new ItemStack(Item.clay), 4, 8), 10.0);
        trommelDropsRichDirt.addEntry(new WeightedRandomLootObject(new ItemStack(Item.ammoPebble), 1, 5), 5.0);
        trommelDropsSoulSand = new WeightedRandomBag();
        trommelDropsSoulSand.addEntry(new WeightedRandomLootObject(new ItemStack(Item.flint), 1, 3), 20.0);
        trommelDropsSoulSand.addEntry(new WeightedRandomLootObject(new ItemStack(Item.bone), 1, 6), 10.0);
        trommelDropsSoulSand.addEntry(new WeightedRandomLootObject(new ItemStack(Item.nuggetGold), 1, 5), 10.0);
        trommelDropsSoulSand.addEntry(new WeightedRandomLootObject(new ItemStack(Item.nuggetIron), 1, 5), 5.0);
        trommelDropsSoulSand.addEntry(new WeightedRandomLootObject(new ItemStack(Item.dustGlowstone), 1, 6), 5.0);
        trommelDropsSoulSand.addEntry(new WeightedRandomLootObject(new ItemStack(Item.quartz), 1, 3), 5.0);
        trommelDropsSoulSand.addEntry(new WeightedRandomLootObject(new ItemStack(Item.nethercoal)), 0.5);
    }
}

