/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.Block;
import net.minecraft.src.BlockLayerSnow;
import net.minecraft.src.EnumLightType;
import net.minecraft.src.Weather;
import net.minecraft.src.World;

public class WeatherSnow
extends Weather {
    public WeatherSnow(int id) {
        super(id);
    }

    @Override
    public void doEnvironmentUpdate(World world, Random rand, int x, int z) {
        int probability = (int)(64.0f * (1.0f / world.weatherPower));
        if (world.currentSeason != null && world.currentSeason.hasDeeperSnow) {
            probability /= 2;
        }
        if (rand.nextInt(probability) == 0) {
            int y = world.getHeightValue(x, z);
            int blockId = world.getBlockId(x, y, z);
            int blockIdBelow = world.getBlockId(x, y - 1, z);
            BiomeGenBase biome = world.getWorldChunkManager().getBiomeGenAt(x, z);
            for (int i = 0; i < biome.blockedWeathers.length; ++i) {
                if (biome.blockedWeathers[i] != this) continue;
                return;
            }
            if (world.weatherPower > 0.6f && y >= 0 && y < Minecraft.WORLD_HEIGHT_BLOCKS && world.getSavedLightValue(EnumLightType.Block, x, y, z) < 10) {
                if (blockId == 0 && blockIdBelow != 0 && Block.layerSnow.canPlaceBlockAt(world, x, y, z) && blockIdBelow != Block.ice.blockID) {
                    world.setBlockWithNotify(x, y, z, Block.layerSnow.blockID);
                } else if (world.weatherPower > 0.5f && blockId == Block.layerSnow.blockID && world.getCurrentSeason() != null && world.getCurrentSeason().hasDeeperSnow) {
                    ((BlockLayerSnow)Block.layerSnow).accumulate(world, x, y, z);
                } else if (blockIdBelow == Block.fluidWaterStill.blockID && world.getBlockMetadata(x, y - 1, z) == 0) {
                    world.setBlockWithNotify(x, y - 1, z, Block.ice.blockID);
                }
            }
        }
    }
}

