/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.World;
import net.minecraft.src.WorldChunkManager;

public class WorldChunkManagerDeeper
extends WorldChunkManager {
    public WorldChunkManagerDeeper(World world) {
        super(world);
    }

    @Override
    public double[] getTemperatures(double[] ad, int i, int j, int k, int l) {
        if (ad == null || ad.length < k * l) {
            ad = new double[k * l];
        }
        ad = this.field_4194_e.func_4112_a(ad, i, j, k, l, 0.00625, 0.00625, 0.25);
        this.fuzziness = this.field_4192_g.func_4112_a(this.fuzziness, i, j, k, l, 8.0, 8.0, 0.025);
        int i1 = 0;
        for (int j1 = 0; j1 < k; ++j1) {
            for (int k1 = 0; k1 < l; ++k1) {
                double d = this.fuzziness[i1] * 1.1 + 2.5;
                double d1 = 0.01;
                double d2 = 1.0 - d1;
                double d3 = (ad[i1] * 0.15 + 0.7) * d2 + d * d1;
                if ((d3 = 1.0 - (1.0 - d3) * (1.0 - d3)) < 0.0) {
                    d3 = 0.0;
                }
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                ad[i1] = d3;
                ++i1;
            }
        }
        return ad;
    }

    @Override
    public BiomeGenBase[] updateBlockGeneratorDataFromHeight(BiomeGenBase[] abiomegenbase, int[] heights, int oceanHeight, int maxTerrainHeight, int x, int y, int width, int length) {
        if (abiomegenbase == null || abiomegenbase.length < width * length) {
            abiomegenbase = new BiomeGenBase[width * length];
        }
        this.temperature = this.field_4194_e.func_4112_a(this.temperature, x, y, width, width, 0.00625, 0.00625, 0.25);
        this.humidity = this.field_4193_f.func_4112_a(this.humidity, x, y, width, width, 0.0125, 0.0125, 0.3);
        this.biomeTemperature = this.field_4194_e.func_4112_a(this.biomeTemperature, x, y, width, width, 0.00625, 0.00625, 0.25);
        this.biomeHumidity = this.field_4193_f.func_4112_a(this.biomeHumidity, x, y, width, width, 0.0125, 0.0125, 0.3);
        this.fuzziness = this.field_4192_g.func_4112_a(this.fuzziness, x, y, width, width, 8.0, 8.0, 0.025);
        int i1 = 0;
        for (int j1 = 0; j1 < width; ++j1) {
            for (int k1 = 0; k1 < length; ++k1) {
                float modifier;
                double d = this.fuzziness[i1] * 1.1 + 0.5;
                int terrainHeight = heights[j1 * 16 + k1];
                int aboveOceanTerrainHeight = terrainHeight - oceanHeight;
                int minHeight = 32;
                int maxHeight = 96;
                if (aboveOceanTerrainHeight <= minHeight) {
                    modifier = 1.0f;
                } else if (aboveOceanTerrainHeight >= maxHeight) {
                    modifier = 0.0f;
                } else {
                    float terrain = (float)(aboveOceanTerrainHeight - minHeight) / (float)(maxHeight - minHeight);
                    terrain += (float)(d * (double)terrain * (double)0.03f);
                    modifier = 1.0f - terrain;
                }
                double d1 = 0.01;
                double d2 = 1.0 - d1;
                double d3 = (this.temperature[i1] * 0.15 + 0.7) * d2 * (double)modifier + d * d1;
                d1 = 0.002;
                d2 = 1.0 - d1;
                double d4 = (this.humidity[i1] * 0.15 + 2.5) * d2 + d * d1;
                d3 = 1.0 - (1.0 - d3) * (1.0 - d3);
                if (d3 < 0.0) {
                    d3 = 0.0;
                }
                if (d4 < 0.0) {
                    d4 = 0.0;
                }
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                if (d4 > 1.0) {
                    d4 = 1.0;
                }
                this.temperature[i1] = d3;
                this.humidity[i1] = d4;
                abiomegenbase[i1++] = BiomeGenBase.getBiomeFromLookup(d3, d4);
            }
        }
        return abiomegenbase;
    }

    @Override
    public BiomeGenBase[] loadBlockGeneratorData(BiomeGenBase[] abiomegenbase, int i, int j, int width, int height) {
        if (abiomegenbase == null || abiomegenbase.length < width * height) {
            abiomegenbase = new BiomeGenBase[width * height];
        }
        this.temperature = this.field_4194_e.func_4112_a(this.temperature, i, j, width, width, 0.00625, 0.00625, 0.25);
        this.humidity = this.field_4193_f.func_4112_a(this.humidity, i, j, width, width, 0.0125, 0.0125, 0.3);
        this.fuzziness = this.field_4192_g.func_4112_a(this.fuzziness, i, j, width, width, 8.0, 8.0, 0.025);
        int i1 = 0;
        for (int j1 = 0; j1 < width; ++j1) {
            for (int k1 = 0; k1 < height; ++k1) {
                double d = this.fuzziness[i1] * 1.1 + 0.25;
                double d1 = 0.01;
                double d2 = 1.0 - d1;
                double d3 = (this.temperature[i1] * 0.15 + 0.7) * d2 + d * d1;
                d1 = 0.01;
                d2 = 1.0 - d1;
                double d4 = (this.humidity[i1] * 0.15 + 0.5) * d2 + d * d1;
                if ((d3 = 1.0 - (1.0 - d3) * (1.0 - d3)) < 0.0) {
                    d3 = 0.0;
                }
                if (d4 < 0.0) {
                    d4 = 0.0;
                }
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                if (d4 > 1.0) {
                    d4 = 1.0;
                }
                this.temperature[i1] = d3;
                this.humidity[i1] = d4;
                abiomegenbase[i1++] = BiomeGenBase.getBiomeFromLookup(d3, d4);
            }
        }
        return abiomegenbase;
    }
}

