/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.TileEntityChest;
import net.minecraft.src.TileEntityMobSpawner;
import net.minecraft.src.World;
import net.minecraft.src.WorldGenerator;

public class WorldGenDungeon
extends WorldGenerator {
    public int blockIdWalls;
    public int blockIdFloor;
    public String mobOverride;

    public WorldGenDungeon(int blockIdWalls, int blockIdFloor, String mobOverride) {
        this.blockIdWalls = blockIdWalls;
        this.blockIdFloor = blockIdFloor;
        this.mobOverride = mobOverride;
    }

    @Override
    public boolean generate(World world, Random random, int i, int j, int k) {
        int height = 3;
        int width = random.nextInt(2) + 2;
        int length = random.nextInt(2) + 2;
        int j1 = 0;
        for (int k1 = i - width - 1; k1 <= i + width + 1; ++k1) {
            for (int j2 = j - 1; j2 <= j + height + 1; ++j2) {
                for (int i3 = k - length - 1; i3 <= k + length + 1; ++i3) {
                    Material material = world.getBlockMaterial(k1, j2, i3);
                    if (j2 == j - 1 && !material.isSolid()) {
                        return false;
                    }
                    if (j2 == j + height + 1 && !material.isSolid()) {
                        return false;
                    }
                    if (k1 != i - width - 1 && k1 != i + width + 1 && i3 != k - length - 1 && i3 != k + length + 1 || j2 != j || !world.isAirBlock(k1, j2, i3) || !world.isAirBlock(k1, j2 + 1, i3)) continue;
                    ++j1;
                }
            }
        }
        if (j1 < 1 || j1 > 5) {
            return false;
        }
        for (int l1 = i - width - 1; l1 <= i + width + 1; ++l1) {
            for (int k2 = j + height; k2 >= j - 1; --k2) {
                for (int j3 = k - length - 1; j3 <= k + length + 1; ++j3) {
                    if (l1 == i - width - 1 || k2 == j - 1 || j3 == k - length - 1 || l1 == i + width + 1 || k2 == j + height + 1 || j3 == k + length + 1) {
                        if (k2 >= 0 && !world.getBlockMaterial(l1, k2 - 1, j3).isSolid()) {
                            world.setBlockWithNotify(l1, k2, j3, 0);
                            continue;
                        }
                        if (!world.getBlockMaterial(l1, k2, j3).isSolid()) continue;
                        if (k2 == j - 1 && random.nextInt(4) != 0) {
                            world.setBlockWithNotify(l1, k2, j3, this.blockIdFloor);
                            continue;
                        }
                        world.setBlockWithNotify(l1, k2, j3, this.blockIdWalls);
                        continue;
                    }
                    world.setBlockWithNotify(l1, k2, j3, 0);
                }
            }
        }
        block6: for (int i2 = 0; i2 < 2; ++i2) {
            for (int l2 = 0; l2 < 3; ++l2) {
                int i4;
                int l3;
                int k3 = i + random.nextInt(width * 2 + 1) - width;
                if (!world.isAirBlock(k3, l3 = j, i4 = k + random.nextInt(length * 2 + 1) - length)) continue;
                int j4 = 0;
                if (world.getBlockMaterial(k3 - 1, l3, i4).isSolid()) {
                    ++j4;
                }
                if (world.getBlockMaterial(k3 + 1, l3, i4).isSolid()) {
                    ++j4;
                }
                if (world.getBlockMaterial(k3, l3, i4 - 1).isSolid()) {
                    ++j4;
                }
                if (world.getBlockMaterial(k3, l3, i4 + 1).isSolid()) {
                    ++j4;
                }
                if (j4 != 1) continue;
                world.setBlockWithNotify(k3, l3, i4, Block.chestPlanksOak.blockID);
                TileEntityChest tileentitychest = (TileEntityChest)world.getBlockTileEntity(k3, l3, i4);
                for (int k4 = 0; k4 < 8; ++k4) {
                    ItemStack itemstack = this.pickCheckLootItem(random);
                    if (itemstack == null) continue;
                    tileentitychest.setInventorySlotContents(random.nextInt(tileentitychest.getSizeInventory()), itemstack);
                }
                continue block6;
            }
        }
        world.setBlockWithNotify(i, j, k, Block.mobspawner.blockID);
        TileEntityMobSpawner tileentitymobspawner = (TileEntityMobSpawner)world.getBlockTileEntity(i, j, k);
        tileentitymobspawner.setMobID(this.pickMobSpawner(random));
        return true;
    }

    private ItemStack pickCheckLootItem(Random random) {
        int i = random.nextInt(14);
        if (i == 0) {
            return new ItemStack(Item.saddle);
        }
        if (i == 1) {
            return new ItemStack(Item.ingotIron, random.nextInt(4) + 1);
        }
        if (i == 2) {
            return new ItemStack(Item.foodBread);
        }
        if (i == 3) {
            return new ItemStack(Item.wheat, random.nextInt(4) + 1);
        }
        if (i == 4) {
            return new ItemStack(Item.sulphur, random.nextInt(4) + 1);
        }
        if (i == 5) {
            return new ItemStack(Item.string, random.nextInt(4) + 1);
        }
        if (i == 6) {
            return new ItemStack(Item.bucket);
        }
        if (i == 7 && random.nextInt(100) == 0) {
            return new ItemStack(Item.foodAppleGold);
        }
        if (i == 8 && random.nextInt(2) == 0) {
            return new ItemStack(Item.dustRedstone, random.nextInt(4) + 1);
        }
        if (i == 9 && random.nextInt(10) == 0) {
            return new ItemStack(Item.itemsList[Item.record13.itemID + random.nextInt(9)]);
        }
        if (i == 10) {
            return new ItemStack(Item.dye, 1, 3);
        }
        if (i == 11) {
            return new ItemStack(Item.itemsList[Block.spongeDry.blockID], random.nextInt(4) + 1);
        }
        if (i == 12) {
            return new ItemStack(Item.bone, random.nextInt(4) + 1);
        }
        if (i == 13) {
            return new ItemStack(Item.foodApple);
        }
        return null;
    }

    private String pickMobSpawner(Random random) {
        if (this.mobOverride != null) {
            return this.mobOverride;
        }
        int i = random.nextInt(4);
        if (i == 0) {
            return "Skeleton";
        }
        if (i == 1 || i == 2) {
            return "Zombie";
        }
        return "Spider";
    }
}

