/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.Block;
import net.minecraft.src.ChunkProviderSky;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.MathHelper;
import net.minecraft.src.Vec3D;
import net.minecraft.src.WorldChunkManagerHell;
import net.minecraft.src.WorldProvider;

public class WorldProviderSky
extends WorldProvider {
    @Override
    public void registerWorldChunkManager() {
        this.worldChunkMgr = new WorldChunkManagerHell(this.worldObj, BiomeGenBase.sky, 0.5, 0.0);
    }

    @Override
    public boolean canRespawnHere() {
        return false;
    }

    @Override
    public IChunkProvider getChunkProvider() {
        return new ChunkProviderSky(this.worldObj, this.worldObj.getRandomSeed());
    }

    @Override
    public float calculateCelestialAngle(long l, float f) {
        return 0.0f;
    }

    @Override
    public float[] calcSunriseSunsetColors(float f, float f1) {
        return null;
    }

    @Override
    public Vec3D func_4096_a(float f, float f1) {
        int i = 0x8080A0;
        float f2 = MathHelper.cos(f * 3.141593f * 2.0f) * 2.0f + 0.5f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        float f3 = (float)(i >> 16 & 0xFF) / 255.0f;
        float f4 = (float)(i >> 8 & 0xFF) / 255.0f;
        float f5 = (float)(i & 0xFF) / 255.0f;
        return Vec3D.createVector(f3 *= f2 * 0.94f + 0.06f, f4 *= f2 * 0.94f + 0.06f, f5 *= f2 * 0.91f + 0.09f);
    }

    @Override
    public boolean func_28112_c() {
        return false;
    }

    @Override
    public float getCloudHeight() {
        return 8.0f;
    }

    @Override
    public boolean canCoordinateBeSpawn(int i, int j) {
        int k = this.worldObj.getFirstUncoveredBlock(i, j);
        if (k == 0) {
            return false;
        }
        return Block.blocksList[k].blockMaterial.getIsSolid();
    }
}

