/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.Chunk;
import net.minecraft.src.ChunkCache;
import net.minecraft.src.Entity;
import net.minecraft.src.ICamera;
import net.minecraft.src.MathHelper;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.RenderEngine;
import net.minecraft.src.RenderItem;
import net.minecraft.src.Tessellator;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityRenderer;
import net.minecraft.src.World;
import org.lwjgl.opengl.GL11;

public class WorldRenderer {
    private RenderEngine renderEngine;
    public World worldObj;
    private int glRenderList = -1;
    private static Tessellator tessellator;
    public static int chunksUpdated;
    public int posX;
    public int posY;
    public int posZ;
    public int sizeWidth;
    public int sizeHeight;
    public int sizeDepth;
    public int posXMinus;
    public int posYMinus;
    public int posZMinus;
    public int posXClip;
    public int posYClip;
    public int posZClip;
    public boolean isInFrustum = false;
    public boolean[] skipRenderPass = new boolean[2];
    public int posXPlus;
    public int posYPlus;
    public int posZPlus;
    public float rendererRadius;
    public boolean needsUpdate;
    public AxisAlignedBB rendererBoundingBox;
    public int chunkIndex;
    public boolean isVisible = true;
    public boolean isWaitingOnOcclusionQuery;
    public int glOcclusionQuery;
    public boolean isChunkLit;
    private boolean isInitialized = false;
    public List tileEntityRenderers = new ArrayList();
    private List tileEntities;

    public WorldRenderer(RenderEngine renderEngine, World world, List list, int i, int j, int k, int l, int i1) {
        this.worldObj = world;
        this.tileEntities = list;
        this.sizeHeight = this.sizeDepth = l;
        this.sizeWidth = this.sizeDepth;
        this.rendererRadius = MathHelper.sqrt_float(this.sizeWidth * this.sizeWidth + this.sizeHeight * this.sizeHeight + this.sizeDepth * this.sizeDepth) / 2.0f;
        this.glRenderList = i1;
        this.posX = -999;
        this.setPosition(i, j, k);
        this.needsUpdate = false;
        this.renderEngine = renderEngine;
    }

    public void setPosition(int i, int j, int k) {
        if (i == this.posX && j == this.posY && k == this.posZ) {
            return;
        }
        this.setDontDraw();
        this.posX = i;
        this.posY = j;
        this.posZ = k;
        this.posXPlus = i + this.sizeWidth / 2;
        this.posYPlus = j + this.sizeHeight / 2;
        this.posZPlus = k + this.sizeDepth / 2;
        this.posXClip = i & 0x3FF;
        this.posYClip = j;
        this.posZClip = k & 0x3FF;
        this.posXMinus = i - this.posXClip;
        this.posYMinus = j - this.posYClip;
        this.posZMinus = k - this.posZClip;
        float f = 6.0f;
        this.rendererBoundingBox = AxisAlignedBB.getBoundingBox((float)i - f, (float)j - f, (float)k - f, (float)(i + this.sizeWidth) + f, (float)(j + this.sizeHeight) + f, (float)(k + this.sizeDepth) + f);
        GL11.glNewList((int)(this.glRenderList + 2), (int)4864);
        RenderItem.renderAABB(AxisAlignedBB.getBoundingBoxFromPool((float)this.posXClip - f, (float)this.posYClip - f, (float)this.posZClip - f, (float)(this.posXClip + this.sizeWidth) + f, (float)(this.posYClip + this.sizeHeight) + f, (float)(this.posZClip + this.sizeDepth) + f));
        GL11.glEndList();
        this.markDirty();
    }

    private void setupGLTranslation() {
        GL11.glTranslatef((float)this.posXClip, (float)this.posYClip, (float)this.posZClip);
    }

    public void updateRenderer() {
        if (!this.needsUpdate) {
            return;
        }
        ++chunksUpdated;
        int i = this.posX;
        int j = this.posY;
        int k = this.posZ;
        int l = this.posX + this.sizeWidth;
        int i1 = this.posY + this.sizeHeight;
        int j1 = this.posZ + this.sizeDepth;
        for (int k1 = 0; k1 < 2; ++k1) {
            this.skipRenderPass[k1] = true;
        }
        Chunk.isLit = false;
        HashSet hashset = new HashSet();
        hashset.addAll(this.tileEntityRenderers);
        this.tileEntityRenderers.clear();
        int l1 = 1;
        ChunkCache chunkcache = new ChunkCache(this.worldObj, i - l1, j - l1, k - l1, l + l1, i1 + l1, j1 + l1);
        RenderBlocks renderblocks = new RenderBlocks(this.worldObj, chunkcache);
        for (int i2 = 0; i2 < 2; ++i2) {
            boolean flag = false;
            boolean flag1 = false;
            boolean flag2 = false;
            for (int j2 = j; j2 < i1; ++j2) {
                for (int k2 = k; k2 < j1; ++k2) {
                    for (int l2 = i; l2 < l; ++l2) {
                        Block block;
                        int j3;
                        TileEntity tileentity;
                        int i3 = chunkcache.getBlockId(l2, j2, k2);
                        if (i3 <= 0) continue;
                        if (!flag2) {
                            flag2 = true;
                            GL11.glNewList((int)(this.glRenderList + i2), (int)4864);
                            GL11.glPushMatrix();
                            this.setupGLTranslation();
                            float f = 1.000001f;
                            GL11.glTranslatef((float)((float)(-this.sizeDepth) / 2.0f), (float)((float)(-this.sizeHeight) / 2.0f), (float)((float)(-this.sizeDepth) / 2.0f));
                            GL11.glScalef((float)f, (float)f, (float)f);
                            GL11.glTranslatef((float)((float)this.sizeDepth / 2.0f), (float)((float)this.sizeHeight / 2.0f), (float)((float)this.sizeDepth / 2.0f));
                            tessellator.startDrawingQuads();
                            tessellator.setTranslationD(-this.posX, -this.posY, -this.posZ);
                        }
                        if (i2 == 0 && Block.isBlockContainer[i3] && TileEntityRenderer.instance.hasSpecialRenderer(tileentity = chunkcache.getBlockTileEntity(l2, j2, k2))) {
                            this.tileEntityRenderers.add(tileentity);
                        }
                        if ((j3 = (block = Block.blocksList[i3]).getRenderBlockPass()) != i2) {
                            flag = true;
                            continue;
                        }
                        if (j3 != i2) continue;
                        flag1 |= renderblocks.renderBlockByRenderType(block, l2, j2, k2);
                        if (!block.hasOverbright) continue;
                        renderblocks.overbright = true;
                        flag1 |= renderblocks.renderBlockByRenderType(block, l2, j2, k2);
                        renderblocks.overbright = false;
                    }
                }
            }
            if (flag2) {
                tessellator.draw();
                GL11.glPopMatrix();
                GL11.glEndList();
                tessellator.setTranslationD(0.0, 0.0, 0.0);
            } else {
                flag1 = false;
            }
            if (flag1) {
                this.skipRenderPass[i2] = false;
            }
            if (!flag) break;
        }
        HashSet hashset1 = new HashSet();
        hashset1.addAll(this.tileEntityRenderers);
        hashset1.removeAll(hashset);
        this.tileEntities.addAll(hashset1);
        hashset.removeAll(this.tileEntityRenderers);
        this.tileEntities.removeAll(hashset);
        this.isChunkLit = Chunk.isLit;
        this.isInitialized = true;
    }

    public float distanceToEntitySquared(Entity entity) {
        float f = (float)(entity.posX - (double)this.posXPlus);
        float f1 = (float)(entity.posY - (double)this.posYPlus);
        float f2 = (float)(entity.posZ - (double)this.posZPlus);
        return f * f + f1 * f1 + f2 * f2;
    }

    public void setDontDraw() {
        for (int i = 0; i < 2; ++i) {
            this.skipRenderPass[i] = true;
        }
        this.isInFrustum = false;
        this.isInitialized = false;
    }

    public void func_1204_c() {
        this.setDontDraw();
        this.worldObj = null;
    }

    public int getGLCallListForPass(int i) {
        if (!this.isInFrustum) {
            return -1;
        }
        if (!this.skipRenderPass[i]) {
            return this.glRenderList + i;
        }
        return -1;
    }

    public void updateInFrustrum(ICamera icamera) {
        this.isInFrustum = icamera.isBoundingBoxInFrustum(this.rendererBoundingBox);
    }

    public void callOcclusionQueryList() {
        GL11.glCallList((int)(this.glRenderList + 2));
    }

    public boolean skipAllRenderPasses() {
        if (!this.isInitialized) {
            return false;
        }
        return this.skipRenderPass[0] && this.skipRenderPass[1];
    }

    public void markDirty() {
        this.needsUpdate = true;
    }

    static {
        chunksUpdated = 0;
        tessellator = Tessellator.instance;
    }
}

