/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.command.commands;

import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.World;
import net.minecraft.src.command.Command;
import net.minecraft.src.command.CommandError;
import net.minecraft.src.command.CommandHandler;
import net.minecraft.src.command.CommandSender;
import net.minecraft.src.command.PlayerCommandSender;

public class SetSpawnCommand
extends Command {
    public SetSpawnCommand() {
        super("setworldspawn", "setspawn");
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        int z;
        int y;
        int x;
        EntityPlayer player = sender.getPlayer();
        if (args.length > 0) {
            try {
                x = Integer.parseInt(args[0]);
                y = Integer.parseInt(args[1]);
                z = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException nfe) {
                throw new CommandError("Coordinates must be integers!");
            }
        } else {
            if (player == null) {
                throw new CommandError("Must be used by a player, or define coordinates!");
            }
            x = (int)Math.floor(player.posX);
            y = (int)Math.floor(player.posY);
            z = (int)Math.floor(player.posZ);
        }
        ChunkCoordinates pos = new ChunkCoordinates(x, y, z);
        World world = handler.getWorld(0);
        world.setSpawnPoint(pos);
        handler.sendCommandFeedback(sender, "Set spawn location to x: " + x + " y: " + y + " z: " + z);
        return true;
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        if (sender instanceof PlayerCommandSender) {
            sender.sendMessage("/setworldspawn");
        }
        sender.sendMessage("/setworldspawn <x> <y> <z>");
    }
}

