/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.command.commands;

import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityPlayerMP;
import net.minecraft.src.World;
import net.minecraft.src.command.Command;
import net.minecraft.src.command.CommandError;
import net.minecraft.src.command.CommandHandler;
import net.minecraft.src.command.CommandSender;
import net.minecraft.src.command.PlayerCommandSender;

public class SpawnCommand
extends Command {
    public SpawnCommand() {
        super("spawn", new String[0]);
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        if (sender instanceof PlayerCommandSender) {
            EntityPlayer player = sender.getPlayer();
            World world = handler.getWorld(player);
            ChunkCoordinates pos = world.getSpawnPoint();
            sender.sendMessage("Teleporting to spawn...");
            if (player instanceof EntityPlayerMP) {
                EntityPlayerMP playerMP = (EntityPlayerMP)player;
                if (playerMP.dimension != 0) {
                    playerMP.mcServer.configManager.sendPlayerToOtherDimension(playerMP, 0);
                }
                playerMP.playerNetServerHandler.teleportTo((double)pos.x + 0.5, (double)pos.y + 0.5, (double)pos.z + 0.5, 0.0f, 0.0f);
            }
            player.setLocationAndAngles((double)pos.x + 0.5, (double)pos.y + 0.5, (double)pos.z + 0.5, 0.0f, 0.0f);
            return true;
        }
        throw new CommandError("Must be used by a player!");
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/spawn");
    }
}

