/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.command.commands;

import java.util.Set;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityList;
import net.minecraft.src.World;
import net.minecraft.src.command.ChatColor;
import net.minecraft.src.command.Command;
import net.minecraft.src.command.CommandError;
import net.minecraft.src.command.CommandHandler;
import net.minecraft.src.command.CommandSender;
import net.minecraft.src.command.PlayerCommandSender;
import net.minecraft.src.command.ServerCommandHandler;

public class SummonCommand
extends Command {
    public SummonCommand() {
        super("summon", new String[0]);
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        if (args.length == 0) {
            return false;
        }
        if (args[0].equalsIgnoreCase("list")) {
            StringBuilder builder = new StringBuilder();
            for (String string : EntityList.stringToClassMapping.keySet()) {
                builder.append(", ").append(string);
            }
            sender.sendMessage(ChatColor.lightGray + "Entities: " + ChatColor.white + builder.toString().substring(2));
            return true;
        }
        Set<String> keySet = EntityList.stringToClassMapping.keySet();
        String id = args[0];
        Class<? extends Entity> entityClass = null;
        for (String str : keySet) {
            if (!str.equalsIgnoreCase(id)) continue;
            id = str;
            entityClass = EntityList.stringToClassMapping.get(id);
        }
        if (entityClass == null) {
            throw new CommandError("Could not find entity \"" + id + "\"");
        }
        World world = sender.getPlayer().worldObj;
        int count = 1;
        if (args.length > 1) {
            count = Integer.parseInt(args[1]);
        }
        if (handler instanceof ServerCommandHandler) {
            count = Math.min(count, handler.asServer().minecraftServer.summonLimit);
        }
        double posX = sender.getPlayer().posX;
        double posY = sender.getPlayer().posY;
        double posZ = sender.getPlayer().posZ;
        if (args.length > 2) {
            posX = Double.parseDouble(args[2]);
            posY = Double.parseDouble(args[3]);
            posZ = Double.parseDouble(args[4]);
        }
        for (int i = 0; i < count; ++i) {
            Entity entity = SummonCommand.createEntity(entityClass, world);
            entity.entityInitOnSpawn();
            entity.setLocationAndAngles(posX, posY, posZ, 0.0f, 0.0f);
            world.entityJoinedWorld(entity);
        }
        handler.sendCommandFeedback(sender, "Summoned " + count + " " + id + " at x: " + SummonCommand.floor10(posX) + " y: " + SummonCommand.floor10(posY) + " z: " + SummonCommand.floor10(posZ));
        return true;
    }

    public static double floor10(double a) {
        return (double)((long)(a * 10.0)) / 10.0;
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        if (sender instanceof PlayerCommandSender) {
            sender.sendMessage("/summon <entity> <count> <x> <y> <z>");
        }
    }

    public static Entity createEntity(Class<? extends Entity> entityClass, World world) {
        try {
            return entityClass.getConstructor(World.class).newInstance(world);
        }
        catch (Exception e) {
            throw new CommandError("Could not create Entity!");
        }
    }
}

