/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.gui.GuiElement;
import org.lwjgl.opengl.GL11;

public class ListLayout {
    public final GuiScreen screen;
    public final List<GuiElement> elements = new ArrayList<GuiElement>();
    public double alignX = 0.0;
    public double alignY = 0.0;
    public double alignSelfX = 0.0;
    public double alignSelfY = 0.0;
    public int offsetX;
    public int offsetY;
    public boolean vertical = true;
    public int margin = 0;
    public int elementWidth = 200;
    public int elementHeight = 20;
    private int listX;
    private int listY;
    private int listWidth;
    private int listHeight;

    public ListLayout(GuiScreen screen) {
        this.screen = screen;
    }

    public ListLayout addElement(GuiElement element) {
        this.elements.add(element);
        return this;
    }

    public void updateElementPositions() {
        int elementCount = this.elements.size();
        if (this.vertical) {
            this.listWidth = this.elementWidth;
            this.listHeight = this.elementHeight * elementCount + (elementCount - 1) * this.margin;
        } else {
            this.listWidth = this.elementWidth * elementCount + (elementCount - 1) * this.margin;
            this.listHeight = this.elementHeight;
        }
        this.listX = ListLayout.mix(0, this.screen.width, this.alignX) + this.offsetX;
        this.listY = ListLayout.mix(0, this.screen.height, this.alignY) + this.offsetY;
        this.listX += ListLayout.mix(0, -this.listWidth, this.alignSelfX);
        this.listY += ListLayout.mix(0, -this.listHeight, this.alignSelfY);
        for (int i = 0; i < this.elements.size(); ++i) {
            GuiElement element = this.elements.get(i);
            element.setWidth(this.elementWidth);
            element.setHeight(this.elementHeight);
            if (this.vertical) {
                element.setX(this.listX);
                element.setY(this.listY + i * this.elementHeight + i * this.margin);
                continue;
            }
            element.setX(this.listX + i * this.elementWidth + i * this.margin);
            element.setY(this.listY);
        }
    }

    public static int mix(int a, int b, double c) {
        return (int)((double)a * (1.0 - c) + (double)b * c);
    }

    public void drawDebug() {
        GL11.glDisable((int)3553);
        GL11.glColor3d((double)0.1, (double)0.1, (double)0.1);
        ListLayout.drawRectangle(this.listX - 1, this.listY - 1, this.listWidth + 2, this.listHeight + 2);
        GL11.glColor3d((double)0.2, (double)0.2, (double)0.2);
        ListLayout.drawRectangle(this.listX, this.listY, this.listWidth, this.listHeight);
        GL11.glColor3d((double)0.4, (double)0.4, (double)0.4);
        for (GuiElement element : this.elements) {
            ListLayout.drawRectangle(element.getX(), element.getY(), element.getWidth(), element.getHeight());
        }
    }

    private static void drawRectangle(int x, int y, int w, int h) {
        GL11.glBegin((int)7);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)x, (double)(y + h));
        GL11.glVertex2d((double)(x + w), (double)(y + h));
        GL11.glVertex2d((double)(x + w), (double)y);
        GL11.glEnd();
    }

    public ListLayout setAlign(double x, double y) {
        this.alignX = x;
        this.alignY = y;
        return this;
    }

    public ListLayout setVertical(boolean vertical) {
        this.vertical = vertical;
        return this;
    }

    public ListLayout setElementSize(int width, int height) {
        this.elementWidth = width;
        this.elementHeight = height;
        return this;
    }

    public ListLayout setOffset(int x, int y) {
        this.offsetX = x;
        this.offsetY = y;
        return this;
    }

    public ListLayout setMargin(int margin) {
        this.margin = margin;
        return this;
    }
}

