/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.helper;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.minecraft.src.TexturePackBase;
import net.minecraft.src.helper.Color;

public abstract class Colors {
    public static final Color[] allChatColors = new Color[16];
    public static final Color[] allPlankColors = new Color[16];

    public static void loadColors(TexturePackBase texturePack) {
        Colors.fillColorArray(texturePack, "/misc/colors_chat.png", allChatColors);
        Colors.fillColorArray(texturePack, "/misc/colors_planks.png", allPlankColors);
    }

    public static void fillColorArray(TexturePackBase texturePack, String path, Color[] colors) {
        try {
            InputStream stream = texturePack != null ? texturePack.getResourceAsStream(path) : Colors.class.getResourceAsStream(path);
            BufferedImage image = ImageIO.read(stream);
            stream.close();
            Colors.fillColorArray(colors, image);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load colors from image: " + path);
        }
    }

    public static Color[] fillColorArray(Color[] colors, BufferedImage image) {
        if (image.getWidth() != colors.length || image.getHeight() != 1) {
            throw new RuntimeException("Invalid Color image size! Must be " + colors.length + " x 1");
        }
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = new Color().setARGB(image.getRGB(i, 0));
        }
        return colors;
    }

    public static BufferedImage createColorImage(Color[] colors, int scale) {
        int w = colors.length * scale;
        int h = scale;
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics g = image.getGraphics();
        for (int i = 0; i < colors.length; ++i) {
            Color c = colors[i];
            g.setColor(new java.awt.Color(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()));
            g.fillRect(i * scale, 0, scale, scale);
        }
        return image;
    }
}

