/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.helper;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.src.helper.Buffer;
import net.minecraft.src.helper.Textures;
import net.minecraft.src.render.Framebuffer;
import net.minecraft.src.render.IRenderer;
import net.minecraft.src.render.Texture;
import org.lwjgl.opengl.ARBFramebufferObject;
import org.lwjgl.opengl.GL11;

public class ScreenshotHelper {
    public final Minecraft minecraft;
    private final Framebuffer framebuffer = new Framebuffer();
    private final Texture colortex = new Texture();
    private final Texture depthtex = new Texture();
    private int width = 1024;
    private int height = 1024;
    private float fov;
    private float yaw;
    private float pitch;
    private IRenderer renderer;
    private int oldWidth;
    private int oldHeight;
    private int immersiveMode;

    public ScreenshotHelper(Minecraft minecraft) {
        this.minecraft = minecraft;
    }

    public void takePanoramaScreenshot() throws Exception {
        try {
            this.setup();
            this.takeScreenshot();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.delete();
        }
    }

    private void takeScreenshot() throws Exception {
        this.minecraft.gameSettings.FoV.value = Float.valueOf(0.6056338f);
        this.minecraft.thePlayer.rotationYaw = 0.0f;
        this.minecraft.thePlayer.rotationPitch = 0.0f;
        this.minecraft.thePlayer.prevRotationYaw = this.minecraft.thePlayer.rotationYaw;
        this.minecraft.thePlayer.prevRotationPitch = this.minecraft.thePlayer.rotationPitch;
        File screenshotFolder = new File(Minecraft.getMinecraftDir(), "screenshots");
        long now = System.currentTimeMillis();
        File[] files = new File[4];
        for (int i = 0; i < 4; ++i) {
            this.minecraft.thePlayer.prevRotationYaw = this.minecraft.thePlayer.rotationYaw = (float)i * 90.0f;
            this.minecraft.entityRenderer.updateCameraAndRender(0.0f);
            BufferedImage image = Textures.getTextureAsImage(this.colortex.id(), false, 0, true);
            File file = new File(screenshotFolder, now + "-" + i + ".png");
            Textures.saveImage(file, image);
            files[i] = file;
        }
        BufferedImage image = new BufferedImage(this.width * 4, this.height, 1);
        Graphics g = image.getGraphics();
        for (int i = 0; i < files.length; ++i) {
            g.drawImage(ImageIO.read(files[i]), this.width * i, 0, null);
        }
        g.dispose();
        Textures.saveImage(new File(screenshotFolder, now + ".png"), image);
    }

    public void setup() {
        this.framebuffer.generate();
        this.colortex.generate();
        this.depthtex.generate();
        Buffer.checkBufferSize(this.width * this.height * 4);
        Buffer.reset();
        this.framebuffer.bind();
        this.colortex.bind();
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.width, (int)this.height, (int)0, (int)6408, (int)5121, (ByteBuffer)Buffer.buffer);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        ARBFramebufferObject.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.colortex.id(), (int)0);
        this.depthtex.bind();
        GL11.glTexImage2D((int)3553, (int)0, (int)6402, (int)this.width, (int)this.height, (int)0, (int)6402, (int)5121, (ByteBuffer)Buffer.buffer);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        ARBFramebufferObject.glFramebufferTexture2D((int)36160, (int)36096, (int)3553, (int)this.depthtex.id(), (int)0);
        this.fov = ((Float)this.minecraft.gameSettings.FoV.value).floatValue();
        this.yaw = this.minecraft.thePlayer.rotationYaw;
        this.pitch = this.minecraft.thePlayer.rotationPitch;
        this.renderer = this.minecraft.render;
        this.oldWidth = this.minecraft.resolution.width;
        this.oldHeight = this.minecraft.resolution.height;
        this.immersiveMode = (Integer)this.minecraft.gameSettings.immersiveMode.value;
        this.minecraft.gameSettings.immersiveMode.value = 2;
        this.minecraft.resolution.width = this.width;
        this.minecraft.resolution.height = this.height;
        this.minecraft.render = null;
    }

    public void delete() {
        ARBFramebufferObject.glBindFramebuffer((int)36160, (int)0);
        this.framebuffer.delete();
        this.colortex.delete();
        this.depthtex.delete();
        this.minecraft.gameSettings.FoV.value = Float.valueOf(this.fov);
        this.minecraft.thePlayer.rotationYaw = this.yaw;
        this.minecraft.thePlayer.rotationPitch = this.pitch;
        this.minecraft.render = this.renderer;
        this.minecraft.resolution.width = this.oldWidth;
        this.minecraft.resolution.height = this.oldHeight;
        this.minecraft.gameSettings.immersiveMode.value = this.immersiveMode;
    }
}

