/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.helper;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.minecraft.client.Minecraft;
import net.minecraft.src.GLAllocation;
import net.minecraft.src.helper.Buffer;
import org.lwjgl.opengl.GL11;

public class Textures {
    public static BufferedImage missingTexture = new BufferedImage(64, 64, 2);

    public static BufferedImage readImage(InputStream stream) {
        if (stream == null) {
            return missingTexture;
        }
        try {
            BufferedImage bufferedimage = ImageIO.read(stream);
            stream.close();
            return bufferedimage;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int[] getImageData(BufferedImage image) {
        int w = image.getWidth();
        int h = image.getHeight();
        int[] imageData = new int[w * h];
        image.getRGB(0, 0, w, h, imageData, 0, w);
        return imageData;
    }

    public static int[] getImageData(BufferedImage image, int[] imageData) {
        int w = image.getWidth();
        int h = image.getHeight();
        image.getRGB(0, 0, w, h, imageData, 0, w);
        return imageData;
    }

    public static BufferedImage unwrapImageByColumns(BufferedImage image) {
        int i = image.getWidth() / 16;
        BufferedImage image2 = new BufferedImage(16, image.getHeight() * i, 2);
        Graphics g = image2.getGraphics();
        for (int j = 0; j < i; ++j) {
            g.drawImage(image, -j * 16, j * image.getHeight(), null);
        }
        g.dispose();
        return image2;
    }

    public static void dumpTextures() {
        System.out.println("Dump Textures...");
        File folder = new File("dumpTextures");
        try {
            File[] files;
            folder.mkdirs();
            for (File file : files = folder.listFiles()) {
                file.delete();
            }
            int i = 0;
            for (Integer texture : GLAllocation.textureNames) {
                String name = "" + i;
                try {
                    Minecraft minecraft = Minecraft.getMinecraft();
                    Map<String, Integer> textures = minecraft.renderEngine.getTextureMap();
                    for (Map.Entry<String, Integer> entry : textures.entrySet()) {
                        if (entry.getValue() != texture) continue;
                        System.out.println(entry.getKey());
                    }
                }
                catch (Exception minecraft) {
                    // empty catch block
                }
                int levels = GL11.glGetTexParameteri((int)3553, (int)33085);
                for (int level = 0; level <= levels; ++level) {
                    Textures.saveImage(new File(folder, name + "_mip" + level + ".png"), Textures.getTextureAsImage(texture, true, level));
                    Textures.saveImage(new File(folder, name + "_mip" + level + "_opaque.png"), Textures.getTextureAsImage(texture, false, level));
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Done!");
        try {
            Minecraft.getMinecraft().ingameGUI.addChatMessage("Dumped textures to " + folder.getAbsolutePath());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void saveImage(File file, BufferedImage image) {
        if (image == null) {
            return;
        }
        try {
            file.createNewFile();
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static BufferedImage getTextureAsImage(int texture, boolean alpha, int level) {
        return Textures.getTextureAsImage(texture, alpha, level, false);
    }

    public static BufferedImage getTextureAsImage(int texture, boolean alpha, int level, boolean mirrorVertical) {
        GL11.glBindTexture((int)3553, (int)texture);
        int w = GL11.glGetTexLevelParameteri((int)3553, (int)level, (int)4096);
        int h = GL11.glGetTexLevelParameteri((int)3553, (int)level, (int)4097);
        if (w == 0 || h == 0) {
            return null;
        }
        System.out.println("Texture " + texture + " Size: " + w + " x " + h);
        Buffer.reset();
        Buffer.checkBufferSize(w * h * 16);
        GL11.glGetTexImage((int)3553, (int)level, (int)6408, (int)5121, (ByteBuffer)Buffer.buffer);
        Buffer.buffer.position(0);
        Buffer.buffer.limit(Buffer.buffer.capacity());
        int[] rgb = new int[w * h];
        for (int i = 0; i < rgb.length; ++i) {
            int c;
            int j = i;
            if (mirrorVertical) {
                int x = i % w;
                int y = i / w;
                y = h - y - 1;
                j = y * w + x;
            }
            int r = Buffer.getInt(j * 4 + 2) & 0xFF;
            int g = Buffer.getInt(j * 4 + 1) & 0xFF;
            int b = Buffer.getInt(j * 4 + 0) & 0xFF;
            int a = Buffer.getInt(j * 4 + 3) & 0xFF;
            if (!alpha) {
                a = 255;
            }
            rgb[i] = c = (r << 0) + (g << 8) + (b << 16) + (a << 24);
        }
        BufferedImage image = new BufferedImage(w, h, alpha ? 2 : 1);
        image.setRGB(0, 0, w, h, rgb, 0, w);
        return image;
    }

    public static void main(String[] args) {
        try {
            final BufferedImage image = Textures.unwrapImageByColumns(ImageIO.read(Textures.class.getResourceAsStream("/terrain.png")));
            JFrame frame = new JFrame();
            frame.setUndecorated(true);
            JPanel panel = new JPanel(){
                private static final long serialVersionUID = 1L;

                @Override
                public void paint(Graphics g) {
                    super.paint(g);
                    g.drawImage(image, 0, 0, null);
                }
            };
            panel.setPreferredSize(new Dimension(image.getWidth(), image.getHeight()));
            frame.add(panel);
            frame.pack();
            frame.setLocationRelativeTo(null);
            frame.setDefaultCloseOperation(2);
            frame.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        Graphics g = missingTexture.getGraphics();
        try {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        catch (Exception exception) {
            // empty catch block
        }
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, 64, 64);
        g.setColor(Color.BLACK);
        g.drawString("missingtex", 1, 10);
        g.dispose();
    }
}

