/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.input;

import java.util.ArrayList;
import java.util.List;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.minecraft.client.Minecraft;
import net.minecraft.src.input.MouseInput;
import net.minecraft.src.input.controller.ControllerInput;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public abstract class InputHandler {
    public static List<ControllerInput> controllers;

    public static void init(Minecraft minecraft) {
        try {
            Keyboard.create();
            Mouse.create();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Controller Init");
        ControllerEnvironment controllerEnvironment = ControllerEnvironment.getDefaultEnvironment();
        ArrayList<ControllerInput> controllerList = new ArrayList<ControllerInput>();
        for (Controller controller : controllerEnvironment.getControllers()) {
            if (controller.getType() == Controller.Type.GAMEPAD) {
                controllerList.add(new ControllerInput(minecraft, controller));
            }
            if (controller.getType() != Controller.Type.MOUSE || minecraft.mouseInput != null) continue;
            minecraft.mouseInput = new MouseInput(minecraft, controller);
        }
        controllers = controllerList;
    }

    public ControllerInput getController(String name) {
        for (ControllerInput controllerInput : controllers) {
            if (!controllerInput.getController().getName().equalsIgnoreCase(name)) continue;
            return controllerInput;
        }
        return null;
    }

    public static Component getComponent(Controller controller, String id) {
        for (Component component : controller.getComponents()) {
            if (!component.getIdentifier().toString().equalsIgnoreCase(id)) continue;
            return component;
        }
        return null;
    }
}

