/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.render;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.src.helper.ResourceProvider;
import org.lwjgl.opengl.GL20;

public class Shader {
    private int program;
    private int vertexShader;
    private int fragmentShader;
    private boolean usable = false;
    private final Map<String, Integer> uniformLocations = new HashMap<String, Integer>();

    public Shader compile(ResourceProvider folder, String name) {
        this.delete();
        if (name == null) {
            return this;
        }
        String f = folder.getString(name + ".fsh");
        String v = folder.getString(name + ".vsh");
        return this.compile(f, v);
    }

    public Shader compile(String fragmentSource, String vertexSource) {
        if (fragmentSource == null) {
            throw new NullPointerException("Fragment Source is null!");
        }
        if (vertexSource == null) {
            throw new NullPointerException("Vertex Source is null!");
        }
        this.delete();
        this.create();
        GL20.glShaderSource((int)this.vertexShader, (CharSequence)vertexSource);
        GL20.glShaderSource((int)this.fragmentShader, (CharSequence)fragmentSource);
        GL20.glCompileShader((int)this.vertexShader);
        GL20.glCompileShader((int)this.fragmentShader);
        Shader.printShaderInfoLog(this.vertexShader, "Vertex Shader");
        Shader.printShaderInfoLog(this.fragmentShader, "Fragment Shader");
        if (Shader.getCompileStatus(this.vertexShader) != 1) {
            this.delete();
            throw new RuntimeException("Vertex Shader Compiler Error!");
        }
        if (Shader.getCompileStatus(this.fragmentShader) != 1) {
            this.delete();
            throw new RuntimeException("Fragment Shader Compiler Error!");
        }
        GL20.glAttachShader((int)this.program, (int)this.fragmentShader);
        GL20.glAttachShader((int)this.program, (int)this.vertexShader);
        GL20.glLinkProgram((int)this.program);
        Shader.printProgramInfoLog(this.program);
        if (GL20.glGetProgrami((int)this.program, (int)35714) != 1) {
            this.delete();
            throw new RuntimeException("Link Error!");
        }
        GL20.glDeleteShader((int)this.vertexShader);
        GL20.glDeleteShader((int)this.fragmentShader);
        this.usable = true;
        return this;
    }

    private void create() {
        this.program = GL20.glCreateProgram();
        if (this.program == 0) {
            throw new RuntimeException("Program not created!");
        }
        this.vertexShader = GL20.glCreateShader((int)35633);
        this.fragmentShader = GL20.glCreateShader((int)35632);
        if (this.vertexShader == 0) {
            throw new RuntimeException("Vertex Shader not created!");
        }
        if (this.fragmentShader == 0) {
            throw new RuntimeException("Fragment Shader not created!");
        }
    }

    public int getUniform(String uniform) {
        Integer u = this.uniformLocations.get(uniform);
        if (u == null) {
            u = GL20.glGetUniformLocation((int)this.program, (CharSequence)uniform);
            this.uniformLocations.put(uniform, u);
        }
        return u;
    }

    public void delete() {
        this.usable = false;
        this.uniformLocations.clear();
        GL20.glDeleteProgram((int)this.program);
        GL20.glDeleteShader((int)this.fragmentShader);
        GL20.glDeleteShader((int)this.vertexShader);
        this.program = 0;
        this.vertexShader = 0;
        this.fragmentShader = 0;
    }

    public boolean isUsable() {
        return this.usable;
    }

    public void bind() {
        if (!this.usable) {
            throw new RuntimeException("Shader is not finished!");
        }
        GL20.glUseProgram((int)this.program);
    }

    public void unbind() {
        GL20.glUseProgram((int)0);
    }

    public static void printShaderInfoLog(int shader, String name) {
        String infoLog = GL20.glGetShaderInfoLog((int)shader, (int)GL20.glGetShaderi((int)shader, (int)35716));
        if (infoLog.length() == 0) {
            return;
        }
        System.out.println(name + " Info Log: ");
        System.out.println("\"" + infoLog + "\"");
    }

    public static void printProgramInfoLog(int program) {
        String infoLog = GL20.glGetProgramInfoLog((int)program, (int)GL20.glGetProgrami((int)program, (int)35716));
        if (infoLog.length() == 0) {
            return;
        }
        System.out.println("Shader Program Info Log: ");
        System.out.println(infoLog);
    }

    public static int getCompileStatus(int shader) {
        return GL20.glGetShaderi((int)shader, (int)35713);
    }

    public void uniformFloat(String name, float value) {
        GL20.glUniform1f((int)this.getUniform(name), (float)value);
    }

    public void uniformFloat(String name, boolean value) {
        this.uniformFloat(name, value ? 1.0f : 0.0f);
    }

    public void uniformInt(String name, int value) {
        GL20.glUniform1i((int)this.getUniform(name), (int)value);
    }
}

